/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a subnet for a VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SubnetConfiguration.Builder, SubnetConfiguration> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(SubnetConfiguration::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> IPV4_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv4")
            .getter(getter(SubnetConfiguration::ipv4))
            .setter(setter(Builder::ipv4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4")
                    .unmarshallLocationName("Ipv4").build()).build();

    private static final SdkField<String> IPV6_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6")
            .getter(getter(SubnetConfiguration::ipv6))
            .setter(setter(Builder::ipv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6")
                    .unmarshallLocationName("Ipv6").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, IPV4_FIELD,
            IPV6_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String ipv4;

    private final String ipv6;

    private SubnetConfiguration(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.ipv4 = builder.ipv4;
        this.ipv6 = builder.ipv6;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address if
     * the VPC endpoint supports IPv4.
     * </p>
     * <p>
     * If you specify an IPv4 address when modifying a VPC endpoint, we replace the existing endpoint network interface
     * with a new endpoint network interface with this IP address. This process temporarily disconnects the subnet and
     * the VPC endpoint.
     * </p>
     * 
     * @return The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4
     *         address if the VPC endpoint supports IPv4.</p>
     *         <p>
     *         If you specify an IPv4 address when modifying a VPC endpoint, we replace the existing endpoint network
     *         interface with a new endpoint network interface with this IP address. This process temporarily
     *         disconnects the subnet and the VPC endpoint.
     */
    public final String ipv4() {
        return ipv4;
    }

    /**
     * <p>
     * The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address if
     * the VPC endpoint supports IPv6.
     * </p>
     * <p>
     * If you specify an IPv6 address when modifying a VPC endpoint, we replace the existing endpoint network interface
     * with a new endpoint network interface with this IP address. This process temporarily disconnects the subnet and
     * the VPC endpoint.
     * </p>
     * 
     * @return The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6
     *         address if the VPC endpoint supports IPv6.</p>
     *         <p>
     *         If you specify an IPv6 address when modifying a VPC endpoint, we replace the existing endpoint network
     *         interface with a new endpoint network interface with this IP address. This process temporarily
     *         disconnects the subnet and the VPC endpoint.
     */
    public final String ipv6() {
        return ipv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetConfiguration)) {
            return false;
        }
        SubnetConfiguration other = (SubnetConfiguration) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(ipv4(), other.ipv4())
                && Objects.equals(ipv6(), other.ipv6());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetConfiguration").add("SubnetId", subnetId()).add("Ipv4", ipv4()).add("Ipv6", ipv6())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Ipv4":
            return Optional.ofNullable(clazz.cast(ipv4()));
        case "Ipv6":
            return Optional.ofNullable(clazz.cast(ipv6()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ipv4", IPV4_FIELD);
        map.put("Ipv6", IPV6_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetConfiguration, T> g) {
        return obj -> g.apply((SubnetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetConfiguration> {
        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address
         * if the VPC endpoint supports IPv4.
         * </p>
         * <p>
         * If you specify an IPv4 address when modifying a VPC endpoint, we replace the existing endpoint network
         * interface with a new endpoint network interface with this IP address. This process temporarily disconnects
         * the subnet and the VPC endpoint.
         * </p>
         * 
         * @param ipv4
         *        The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4
         *        address if the VPC endpoint supports IPv4.</p>
         *        <p>
         *        If you specify an IPv4 address when modifying a VPC endpoint, we replace the existing endpoint network
         *        interface with a new endpoint network interface with this IP address. This process temporarily
         *        disconnects the subnet and the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4(String ipv4);

        /**
         * <p>
         * The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address
         * if the VPC endpoint supports IPv6.
         * </p>
         * <p>
         * If you specify an IPv6 address when modifying a VPC endpoint, we replace the existing endpoint network
         * interface with a new endpoint network interface with this IP address. This process temporarily disconnects
         * the subnet and the VPC endpoint.
         * </p>
         * 
         * @param ipv6
         *        The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6
         *        address if the VPC endpoint supports IPv6.</p>
         *        <p>
         *        If you specify an IPv6 address when modifying a VPC endpoint, we replace the existing endpoint network
         *        interface with a new endpoint network interface with this IP address. This process temporarily
         *        disconnects the subnet and the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6(String ipv6);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String ipv4;

        private String ipv6;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetConfiguration model) {
            subnetId(model.subnetId);
            ipv4(model.ipv4);
            ipv6(model.ipv6);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIpv4() {
            return ipv4;
        }

        public final void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        @Override
        public final Builder ipv4(String ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public final String getIpv6() {
            return ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        @Override
        public SubnetConfiguration build() {
            return new SubnetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
