/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AllocationIdListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.PublicIpStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddressesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeAddressesRequest> {
    private static final SdkField<List<String>> PUBLIC_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicIps").getter(DescribeAddressesRequest.getter(DescribeAddressesRequest::publicIps)).setter(DescribeAddressesRequest.setter(Builder::publicIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("PublicIp").build(), ListTrait.builder().memberLocationName("PublicIp").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("PublicIp").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeAddressesRequest.getter(DescribeAddressesRequest::dryRun)).setter(DescribeAddressesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeAddressesRequest.getter(DescribeAddressesRequest::filters)).setter(DescribeAddressesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationIds").getter(DescribeAddressesRequest.getter(DescribeAddressesRequest::allocationIds)).setter(DescribeAddressesRequest.setter(Builder::allocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build(), ListTrait.builder().memberLocationName("AllocationId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("AllocationId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IPS_FIELD, DRY_RUN_FIELD, FILTERS_FIELD, ALLOCATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAddressesRequest.memberNameToFieldInitializer();
    private final List<String> publicIps;
    private final Boolean dryRun;
    private final List<Filter> filters;
    private final List<String> allocationIds;

    private DescribeAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.publicIps = builder.publicIps;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
        this.allocationIds = builder.allocationIds;
    }

    public final boolean hasPublicIps() {
        return this.publicIps != null && !(this.publicIps instanceof SdkAutoConstructList);
    }

    public final List<String> publicIps() {
        return this.publicIps;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final boolean hasAllocationIds() {
        return this.allocationIds != null && !(this.allocationIds instanceof SdkAutoConstructList);
    }

    public final List<String> allocationIds() {
        return this.allocationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicIps() ? this.publicIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationIds() ? this.allocationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest)((Object)obj);
        return this.hasPublicIps() == other.hasPublicIps() && Objects.equals(this.publicIps(), other.publicIps()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAllocationIds() == other.hasAllocationIds() && Objects.equals(this.allocationIds(), other.allocationIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAddressesRequest").add("PublicIps", this.hasPublicIps() ? this.publicIps() : null).add("DryRun", (Object)this.dryRun()).add("Filters", this.hasFilters() ? this.filters() : null).add("AllocationIds", this.hasAllocationIds() ? this.allocationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIps": {
                return Optional.ofNullable(clazz.cast(this.publicIps()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "AllocationIds": {
                return Optional.ofNullable(clazz.cast(this.allocationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PublicIp", PUBLIC_IPS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("AllocationId", ALLOCATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesRequest, T> g) {
        return obj -> g.apply((DescribeAddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> publicIps = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> allocationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesRequest model) {
            super(model);
            this.publicIps(model.publicIps);
            this.dryRun(model.dryRun);
            this.filters(model.filters);
            this.allocationIds(model.allocationIds);
        }

        public final Collection<String> getPublicIps() {
            if (this.publicIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicIps;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String ... publicIps) {
            this.publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllocationIds() {
            if (this.allocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allocationIds;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String ... allocationIds) {
            this.allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddressesRequest build() {
            return new DescribeAddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddressesRequest> {
        public Builder publicIps(Collection<String> var1);

        public Builder publicIps(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder allocationIds(Collection<String> var1);

        public Builder allocationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

