/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnassignIpv6AddressesResponse extends Ec2Response implements
        ToCopyableBuilder<UnassignIpv6AddressesResponse.Builder, UnassignIpv6AddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(UnassignIpv6AddressesResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> UNASSIGNED_IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UnassignedIpv6Addresses")
            .getter(getter(UnassignIpv6AddressesResponse::unassignedIpv6Addresses))
            .setter(setter(Builder::unassignedIpv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnassignedIpv6Addresses")
                    .unmarshallLocationName("unassignedIpv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> UNASSIGNED_IPV6_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UnassignedIpv6Prefixes")
            .getter(getter(UnassignIpv6AddressesResponse::unassignedIpv6Prefixes))
            .setter(setter(Builder::unassignedIpv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnassignedIpv6PrefixSet")
                    .unmarshallLocationName("unassignedIpv6PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            UNASSIGNED_IPV6_ADDRESSES_FIELD, UNASSIGNED_IPV6_PREFIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkInterfaceId;

    private final List<String> unassignedIpv6Addresses;

    private final List<String> unassignedIpv6Prefixes;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
        this.unassignedIpv6Prefixes = builder.unassignedIpv6Prefixes;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnassignedIpv6Addresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnassignedIpv6Addresses() {
        return unassignedIpv6Addresses != null && !(unassignedIpv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses that have been unassigned from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnassignedIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses that have been unassigned from the network interface.
     */
    public final List<String> unassignedIpv6Addresses() {
        return unassignedIpv6Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnassignedIpv6Prefixes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnassignedIpv6Prefixes() {
        return unassignedIpv6Prefixes != null && !(unassignedIpv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 prefixes that have been unassigned from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnassignedIpv6Prefixes} method.
     * </p>
     * 
     * @return The IPv4 prefixes that have been unassigned from the network interface.
     */
    public final List<String> unassignedIpv6Prefixes() {
        return unassignedIpv6Prefixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnassignedIpv6Addresses() ? unassignedIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnassignedIpv6Prefixes() ? unassignedIpv6Prefixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasUnassignedIpv6Addresses() == other.hasUnassignedIpv6Addresses()
                && Objects.equals(unassignedIpv6Addresses(), other.unassignedIpv6Addresses())
                && hasUnassignedIpv6Prefixes() == other.hasUnassignedIpv6Prefixes()
                && Objects.equals(unassignedIpv6Prefixes(), other.unassignedIpv6Prefixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnassignIpv6AddressesResponse").add("NetworkInterfaceId", networkInterfaceId())
                .add("UnassignedIpv6Addresses", hasUnassignedIpv6Addresses() ? unassignedIpv6Addresses() : null)
                .add("UnassignedIpv6Prefixes", hasUnassignedIpv6Prefixes() ? unassignedIpv6Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "UnassignedIpv6Addresses":
            return Optional.ofNullable(clazz.cast(unassignedIpv6Addresses()));
        case "UnassignedIpv6Prefixes":
            return Optional.ofNullable(clazz.cast(unassignedIpv6Prefixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("UnassignedIpv6Addresses", UNASSIGNED_IPV6_ADDRESSES_FIELD);
        map.put("UnassignedIpv6PrefixSet", UNASSIGNED_IPV6_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnassignIpv6AddressesResponse, T> g) {
        return obj -> g.apply((UnassignIpv6AddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses);

        /**
         * <p>
         * The IPv4 prefixes that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Prefixes
         *        The IPv4 prefixes that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Prefixes(Collection<String> unassignedIpv6Prefixes);

        /**
         * <p>
         * The IPv4 prefixes that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Prefixes
         *        The IPv4 prefixes that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Prefixes(String... unassignedIpv6Prefixes);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<String> unassignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> unassignedIpv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            super(model);
            networkInterfaceId(model.networkInterfaceId);
            unassignedIpv6Addresses(model.unassignedIpv6Addresses);
            unassignedIpv6Prefixes(model.unassignedIpv6Prefixes);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            if (unassignedIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return unassignedIpv6Addresses;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses) {
            unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final Collection<String> getUnassignedIpv6Prefixes() {
            if (unassignedIpv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return unassignedIpv6Prefixes;
        }

        public final void setUnassignedIpv6Prefixes(Collection<String> unassignedIpv6Prefixes) {
            this.unassignedIpv6Prefixes = IpPrefixListCopier.copy(unassignedIpv6Prefixes);
        }

        @Override
        public final Builder unassignedIpv6Prefixes(Collection<String> unassignedIpv6Prefixes) {
            this.unassignedIpv6Prefixes = IpPrefixListCopier.copy(unassignedIpv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Prefixes(String... unassignedIpv6Prefixes) {
            unassignedIpv6Prefixes(Arrays.asList(unassignedIpv6Prefixes));
            return this;
        }

        @Override
        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
