/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the errors that occurred when disabling fast snapshot restores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableFastSnapshotRestoreErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DisableFastSnapshotRestoreErrorItem.Builder, DisableFastSnapshotRestoreErrorItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(DisableFastSnapshotRestoreErrorItem::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<List<DisableFastSnapshotRestoreStateErrorItem>> FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD = SdkField
            .<List<DisableFastSnapshotRestoreStateErrorItem>> builder(MarshallingType.LIST)
            .memberName("FastSnapshotRestoreStateErrors")
            .getter(getter(DisableFastSnapshotRestoreErrorItem::fastSnapshotRestoreStateErrors))
            .setter(setter(Builder::fastSnapshotRestoreStateErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastSnapshotRestoreStateErrorSet")
                    .unmarshallLocationName("fastSnapshotRestoreStateErrorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DisableFastSnapshotRestoreStateErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisableFastSnapshotRestoreStateErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final List<DisableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors;

    private DisableFastSnapshotRestoreErrorItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.fastSnapshotRestoreStateErrors = builder.fastSnapshotRestoreStateErrors;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FastSnapshotRestoreStateErrors property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFastSnapshotRestoreStateErrors() {
        return fastSnapshotRestoreStateErrors != null && !(fastSnapshotRestoreStateErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFastSnapshotRestoreStateErrors} method.
     * </p>
     * 
     * @return The errors.
     */
    public final List<DisableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors() {
        return fastSnapshotRestoreStateErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFastSnapshotRestoreStateErrors() ? fastSnapshotRestoreStateErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoreErrorItem)) {
            return false;
        }
        DisableFastSnapshotRestoreErrorItem other = (DisableFastSnapshotRestoreErrorItem) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && hasFastSnapshotRestoreStateErrors() == other.hasFastSnapshotRestoreStateErrors()
                && Objects.equals(fastSnapshotRestoreStateErrors(), other.fastSnapshotRestoreStateErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DisableFastSnapshotRestoreErrorItem")
                .add("SnapshotId", snapshotId())
                .add("FastSnapshotRestoreStateErrors",
                        hasFastSnapshotRestoreStateErrors() ? fastSnapshotRestoreStateErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "FastSnapshotRestoreStateErrors":
            return Optional.ofNullable(clazz.cast(fastSnapshotRestoreStateErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("FastSnapshotRestoreStateErrorSet", FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoreErrorItem, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoreErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisableFastSnapshotRestoreErrorItem> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The errors.
         * </p>
         * 
         * @param fastSnapshotRestoreStateErrors
         *        The errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastSnapshotRestoreStateErrors(Collection<DisableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors);

        /**
         * <p>
         * The errors.
         * </p>
         * 
         * @param fastSnapshotRestoreStateErrors
         *        The errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastSnapshotRestoreStateErrors(DisableFastSnapshotRestoreStateErrorItem... fastSnapshotRestoreStateErrors);

        /**
         * <p>
         * The errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #fastSnapshotRestoreStateErrors(List<DisableFastSnapshotRestoreStateErrorItem>)}.
         * 
         * @param fastSnapshotRestoreStateErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fastSnapshotRestoreStateErrors(java.util.Collection<DisableFastSnapshotRestoreStateErrorItem>)
         */
        Builder fastSnapshotRestoreStateErrors(
                Consumer<DisableFastSnapshotRestoreStateErrorItem.Builder>... fastSnapshotRestoreStateErrors);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private List<DisableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoreErrorItem model) {
            snapshotId(model.snapshotId);
            fastSnapshotRestoreStateErrors(model.fastSnapshotRestoreStateErrors);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final List<DisableFastSnapshotRestoreStateErrorItem.Builder> getFastSnapshotRestoreStateErrors() {
            List<DisableFastSnapshotRestoreStateErrorItem.Builder> result = DisableFastSnapshotRestoreStateErrorSetCopier
                    .copyToBuilder(this.fastSnapshotRestoreStateErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFastSnapshotRestoreStateErrors(
                Collection<DisableFastSnapshotRestoreStateErrorItem.BuilderImpl> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = DisableFastSnapshotRestoreStateErrorSetCopier
                    .copyFromBuilder(fastSnapshotRestoreStateErrors);
        }

        @Override
        public final Builder fastSnapshotRestoreStateErrors(
                Collection<DisableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = DisableFastSnapshotRestoreStateErrorSetCopier
                    .copy(fastSnapshotRestoreStateErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(
                DisableFastSnapshotRestoreStateErrorItem... fastSnapshotRestoreStateErrors) {
            fastSnapshotRestoreStateErrors(Arrays.asList(fastSnapshotRestoreStateErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(
                Consumer<DisableFastSnapshotRestoreStateErrorItem.Builder>... fastSnapshotRestoreStateErrors) {
            fastSnapshotRestoreStateErrors(Stream.of(fastSnapshotRestoreStateErrors)
                    .map(c -> DisableFastSnapshotRestoreStateErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisableFastSnapshotRestoreErrorItem build() {
            return new DisableFastSnapshotRestoreErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
