/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcBlockPublicAccessExclusionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcBlockPublicAccessExclusionRequest.Builder, CreateVpcBlockPublicAccessExclusionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateVpcBlockPublicAccessExclusionRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(CreateVpcBlockPublicAccessExclusionRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateVpcBlockPublicAccessExclusionRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_EXCLUSION_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayExclusionMode")
            .getter(getter(CreateVpcBlockPublicAccessExclusionRequest::internetGatewayExclusionModeAsString))
            .setter(setter(Builder::internetGatewayExclusionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayExclusionMode")
                    .unmarshallLocationName("InternetGatewayExclusionMode").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVpcBlockPublicAccessExclusionRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            SUBNET_ID_FIELD, VPC_ID_FIELD, INTERNET_GATEWAY_EXCLUSION_MODE_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String subnetId;

    private final String vpcId;

    private final String internetGatewayExclusionMode;

    private final List<TagSpecification> tagSpecifications;

    private CreateVpcBlockPublicAccessExclusionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.internetGatewayExclusionMode = builder.internetGatewayExclusionMode;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A subnet ID.
     * </p>
     * 
     * @return A subnet ID.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * A VPC ID.
     * </p>
     * 
     * @return A VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The exclusion mode for internet gateway traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block inbound
     * internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
     * Bidirectional.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayExclusionMode} will return {@link InternetGatewayExclusionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #internetGatewayExclusionModeAsString}.
     * </p>
     * 
     * @return The exclusion mode for internet gateway traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
     *         inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is
     *         set to Bidirectional.
     *         </p>
     *         </li>
     * @see InternetGatewayExclusionMode
     */
    public final InternetGatewayExclusionMode internetGatewayExclusionMode() {
        return InternetGatewayExclusionMode.fromValue(internetGatewayExclusionMode);
    }

    /**
     * <p>
     * The exclusion mode for internet gateway traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block inbound
     * internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
     * Bidirectional.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayExclusionMode} will return {@link InternetGatewayExclusionMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #internetGatewayExclusionModeAsString}.
     * </p>
     * 
     * @return The exclusion mode for internet gateway traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
     *         inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is
     *         set to Bidirectional.
     *         </p>
     *         </li>
     * @see InternetGatewayExclusionMode
     */
    public final String internetGatewayExclusionModeAsString() {
        return internetGatewayExclusionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter
     * name and the tag value as the filter value. For example, to find all resources that have a tag with the key
     * <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and
     * <code>TeamA</code> for the filter value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the
     *         filter name and the tag value as the filter value. For example, to find all resources that have a tag
     *         with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
     *         filter name and <code>TeamA</code> for the filter value.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayExclusionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcBlockPublicAccessExclusionRequest)) {
            return false;
        }
        CreateVpcBlockPublicAccessExclusionRequest other = (CreateVpcBlockPublicAccessExclusionRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(internetGatewayExclusionModeAsString(), other.internetGatewayExclusionModeAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcBlockPublicAccessExclusionRequest").add("DryRun", dryRun()).add("SubnetId", subnetId())
                .add("VpcId", vpcId()).add("InternetGatewayExclusionMode", internetGatewayExclusionModeAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "InternetGatewayExclusionMode":
            return Optional.ofNullable(clazz.cast(internetGatewayExclusionModeAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("InternetGatewayExclusionMode", INTERNET_GATEWAY_EXCLUSION_MODE_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcBlockPublicAccessExclusionRequest, T> g) {
        return obj -> g.apply((CreateVpcBlockPublicAccessExclusionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcBlockPublicAccessExclusionRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A subnet ID.
         * </p>
         * 
         * @param subnetId
         *        A subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * A VPC ID.
         * </p>
         * 
         * @param vpcId
         *        A VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The exclusion mode for internet gateway traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block inbound
         * internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
         * Bidirectional.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayExclusionMode
         *        The exclusion mode for internet gateway traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and
         *        subnets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
         *        inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access
         *        is set to Bidirectional.
         *        </p>
         *        </li>
         * @see InternetGatewayExclusionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayExclusionMode
         */
        Builder internetGatewayExclusionMode(String internetGatewayExclusionMode);

        /**
         * <p>
         * The exclusion mode for internet gateway traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and subnets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block inbound
         * internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access is set to
         * Bidirectional.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayExclusionMode
         *        The exclusion mode for internet gateway traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-bidirectional</code>: Allow all internet traffic to and from the excluded VPCs and
         *        subnets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allow-egress</code>: Allow outbound internet traffic from the excluded VPCs and subnets. Block
         *        inbound internet traffic to the excluded VPCs and subnets. Only applies when VPC Block Public Access
         *        is set to Bidirectional.
         *        </p>
         *        </li>
         * @see InternetGatewayExclusionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayExclusionMode
         */
        Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode);

        /**
         * <p>
         * <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter
         * name and the tag value as the filter value. For example, to find all resources that have a tag with the key
         * <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and
         * <code>TeamA</code> for the filter value.
         * </p>
         * 
         * @param tagSpecifications
         *        <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the
         *        filter name and the tag value as the filter value. For example, to find all resources that have a tag
         *        with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for
         *        the filter name and <code>TeamA</code> for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter
         * name and the tag value as the filter value. For example, to find all resources that have a tag with the key
         * <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and
         * <code>TeamA</code> for the filter value.
         * </p>
         * 
         * @param tagSpecifications
         *        <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the
         *        filter name and the tag value as the filter value. For example, to find all resources that have a tag
         *        with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for
         *        the filter name and <code>TeamA</code> for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * <code>tag</code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter
         * name and the tag value as the filter value. For example, to find all resources that have a tag with the key
         * <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and
         * <code>TeamA</code> for the filter value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String subnetId;

        private String vpcId;

        private String internetGatewayExclusionMode;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcBlockPublicAccessExclusionRequest model) {
            super(model);
            dryRun(model.dryRun);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            internetGatewayExclusionMode(model.internetGatewayExclusionMode);
            tagSpecifications(model.tagSpecifications);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getInternetGatewayExclusionMode() {
            return internetGatewayExclusionMode;
        }

        public final void setInternetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
        }

        @Override
        public final Builder internetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
            return this;
        }

        @Override
        public final Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode(internetGatewayExclusionMode == null ? null : internetGatewayExclusionMode
                    .toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcBlockPublicAccessExclusionRequest build() {
            return new CreateVpcBlockPublicAccessExclusionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
