/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the client-specific data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientData implements SdkPojo, Serializable, ToCopyableBuilder<ClientData.Builder, ClientData> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(ClientData::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<Instant> UPLOAD_END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UploadEnd")
            .getter(getter(ClientData::uploadEnd))
            .setter(setter(Builder::uploadEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadEnd")
                    .unmarshallLocationName("UploadEnd").build()).build();

    private static final SdkField<Double> UPLOAD_SIZE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("UploadSize")
            .getter(getter(ClientData::uploadSize))
            .setter(setter(Builder::uploadSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadSize")
                    .unmarshallLocationName("UploadSize").build()).build();

    private static final SdkField<Instant> UPLOAD_START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UploadStart")
            .getter(getter(ClientData::uploadStart))
            .setter(setter(Builder::uploadStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadStart")
                    .unmarshallLocationName("UploadStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD,
            UPLOAD_END_FIELD, UPLOAD_SIZE_FIELD, UPLOAD_START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final Instant uploadEnd;

    private final Double uploadSize;

    private final Instant uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    /**
     * <p>
     * A user-defined comment about the disk upload.
     * </p>
     * 
     * @return A user-defined comment about the disk upload.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The time that the disk upload ends.
     * </p>
     * 
     * @return The time that the disk upload ends.
     */
    public final Instant uploadEnd() {
        return uploadEnd;
    }

    /**
     * <p>
     * The size of the uploaded disk image, in GiB.
     * </p>
     * 
     * @return The size of the uploaded disk image, in GiB.
     */
    public final Double uploadSize() {
        return uploadSize;
    }

    /**
     * <p>
     * The time that the disk upload starts.
     * </p>
     * 
     * @return The time that the disk upload starts.
     */
    public final Instant uploadStart() {
        return uploadStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(uploadEnd());
        hashCode = 31 * hashCode + Objects.hashCode(uploadSize());
        hashCode = 31 * hashCode + Objects.hashCode(uploadStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(uploadEnd(), other.uploadEnd())
                && Objects.equals(uploadSize(), other.uploadSize()) && Objects.equals(uploadStart(), other.uploadStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientData").add("Comment", comment()).add("UploadEnd", uploadEnd())
                .add("UploadSize", uploadSize()).add("UploadStart", uploadStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "UploadEnd":
            return Optional.ofNullable(clazz.cast(uploadEnd()));
        case "UploadSize":
            return Optional.ofNullable(clazz.cast(uploadSize()));
        case "UploadStart":
            return Optional.ofNullable(clazz.cast(uploadStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Comment", COMMENT_FIELD);
        map.put("UploadEnd", UPLOAD_END_FIELD);
        map.put("UploadSize", UPLOAD_SIZE_FIELD);
        map.put("UploadStart", UPLOAD_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientData, T> g) {
        return obj -> g.apply((ClientData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientData> {
        /**
         * <p>
         * A user-defined comment about the disk upload.
         * </p>
         * 
         * @param comment
         *        A user-defined comment about the disk upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The time that the disk upload ends.
         * </p>
         * 
         * @param uploadEnd
         *        The time that the disk upload ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadEnd(Instant uploadEnd);

        /**
         * <p>
         * The size of the uploaded disk image, in GiB.
         * </p>
         * 
         * @param uploadSize
         *        The size of the uploaded disk image, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSize(Double uploadSize);

        /**
         * <p>
         * The time that the disk upload starts.
         * </p>
         * 
         * @param uploadStart
         *        The time that the disk upload starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadStart(Instant uploadStart);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private Instant uploadEnd;

        private Double uploadSize;

        private Instant uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            comment(model.comment);
            uploadEnd(model.uploadEnd);
            uploadSize(model.uploadSize);
            uploadStart(model.uploadStart);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getUploadEnd() {
            return uploadEnd;
        }

        public final void setUploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
            return this;
        }

        public final Double getUploadSize() {
            return uploadSize;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final Instant getUploadStart() {
            return uploadStart;
        }

        public final void setUploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
        }

        @Override
        public final Builder uploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
            return this;
        }

        @Override
        public ClientData build() {
            return new ClientData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
