/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSubnetCidrBlockRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateSubnetCidrBlockRequest.Builder, AssociateSubnetCidrBlockRequest> {
    private static final SdkField<String> IPV6_IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6IpamPoolId")
            .getter(getter(AssociateSubnetCidrBlockRequest::ipv6IpamPoolId))
            .setter(setter(Builder::ipv6IpamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6IpamPoolId")
                    .unmarshallLocationName("Ipv6IpamPoolId").build()).build();

    private static final SdkField<Integer> IPV6_NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6NetmaskLength")
            .getter(getter(AssociateSubnetCidrBlockRequest::ipv6NetmaskLength))
            .setter(setter(Builder::ipv6NetmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6NetmaskLength")
                    .unmarshallLocationName("Ipv6NetmaskLength").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(AssociateSubnetCidrBlockRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(AssociateSubnetCidrBlockRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("ipv6CidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_IPAM_POOL_ID_FIELD,
            IPV6_NETMASK_LENGTH_FIELD, SUBNET_ID_FIELD, IPV6_CIDR_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ipv6IpamPoolId;

    private final Integer ipv6NetmaskLength;

    private final String subnetId;

    private final String ipv6CidrBlock;

    private AssociateSubnetCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
        this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
        this.subnetId = builder.subnetId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
    }

    /**
     * <p>
     * An IPv6 IPAM pool ID.
     * </p>
     * 
     * @return An IPv6 IPAM pool ID.
     */
    public final String ipv6IpamPoolId() {
        return ipv6IpamPoolId;
    }

    /**
     * <p>
     * An IPv6 netmask length.
     * </p>
     * 
     * @return An IPv6 netmask length.
     */
    public final Integer ipv6NetmaskLength() {
        return ipv6NetmaskLength;
    }

    /**
     * <p>
     * The ID of your subnet.
     * </p>
     * 
     * @return The ID of your subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The IPv6 CIDR block for your subnet.
     * </p>
     * 
     * @return The IPv6 CIDR block for your subnet.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipv6IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockRequest)) {
            return false;
        }
        AssociateSubnetCidrBlockRequest other = (AssociateSubnetCidrBlockRequest) obj;
        return Objects.equals(ipv6IpamPoolId(), other.ipv6IpamPoolId())
                && Objects.equals(ipv6NetmaskLength(), other.ipv6NetmaskLength()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSubnetCidrBlockRequest").add("Ipv6IpamPoolId", ipv6IpamPoolId())
                .add("Ipv6NetmaskLength", ipv6NetmaskLength()).add("SubnetId", subnetId()).add("Ipv6CidrBlock", ipv6CidrBlock())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipv6IpamPoolId()));
        case "Ipv6NetmaskLength":
            return Optional.ofNullable(clazz.cast(ipv6NetmaskLength()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv6IpamPoolId", IPV6_IPAM_POOL_ID_FIELD);
        map.put("Ipv6NetmaskLength", IPV6_NETMASK_LENGTH_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSubnetCidrBlockRequest, T> g) {
        return obj -> g.apply((AssociateSubnetCidrBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
        /**
         * <p>
         * An IPv6 IPAM pool ID.
         * </p>
         * 
         * @param ipv6IpamPoolId
         *        An IPv6 IPAM pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6IpamPoolId(String ipv6IpamPoolId);

        /**
         * <p>
         * An IPv6 netmask length.
         * </p>
         * 
         * @param ipv6NetmaskLength
         *        An IPv6 netmask length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6NetmaskLength(Integer ipv6NetmaskLength);

        /**
         * <p>
         * The ID of your subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of your subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IPv6 CIDR block for your subnet.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block for your subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String ipv6IpamPoolId;

        private Integer ipv6NetmaskLength;

        private String subnetId;

        private String ipv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockRequest model) {
            super(model);
            ipv6IpamPoolId(model.ipv6IpamPoolId);
            ipv6NetmaskLength(model.ipv6NetmaskLength);
            subnetId(model.subnetId);
            ipv6CidrBlock(model.ipv6CidrBlock);
        }

        public final String getIpv6IpamPoolId() {
            return ipv6IpamPoolId;
        }

        public final void setIpv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
        }

        @Override
        public final Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        public final Integer getIpv6NetmaskLength() {
            return ipv6NetmaskLength;
        }

        public final void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
        }

        @Override
        public final Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSubnetCidrBlockRequest build() {
            return new AssociateSubnetCidrBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
