/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessInstanceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVerifiedAccessInstanceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::description)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::tagSpecifications)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::clientToken)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::dryRun)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Boolean> FIPS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FIPSEnabled").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::fipsEnabled)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::fipsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FIPSEnabled").unmarshallLocationName("FIPSEnabled").build()}).build();
    private static final SdkField<String> CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrEndpointsCustomSubDomain").getter(CreateVerifiedAccessInstanceRequest.getter(CreateVerifiedAccessInstanceRequest::cidrEndpointsCustomSubDomain)).setter(CreateVerifiedAccessInstanceRequest.setter(Builder::cidrEndpointsCustomSubDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrEndpointsCustomSubDomain").unmarshallLocationName("CidrEndpointsCustomSubDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, FIPS_ENABLED_FIELD, CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("FIPSEnabled", FIPS_ENABLED_FIELD);
            this.put("CidrEndpointsCustomSubDomain", CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD);
        }
    });
    private final String description;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final Boolean dryRun;
    private final Boolean fipsEnabled;
    private final String cidrEndpointsCustomSubDomain;

    private CreateVerifiedAccessInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.fipsEnabled = builder.fipsEnabled;
        this.cidrEndpointsCustomSubDomain = builder.cidrEndpointsCustomSubDomain;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean fipsEnabled() {
        return this.fipsEnabled;
    }

    public final String cidrEndpointsCustomSubDomain() {
        return this.cidrEndpointsCustomSubDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.fipsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrEndpointsCustomSubDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessInstanceRequest)) {
            return false;
        }
        CreateVerifiedAccessInstanceRequest other = (CreateVerifiedAccessInstanceRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.fipsEnabled(), other.fipsEnabled()) && Objects.equals(this.cidrEndpointsCustomSubDomain(), other.cidrEndpointsCustomSubDomain());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessInstanceRequest").add("Description", (Object)this.description()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("FIPSEnabled", (Object)this.fipsEnabled()).add("CidrEndpointsCustomSubDomain", (Object)this.cidrEndpointsCustomSubDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "FIPSEnabled": {
                return Optional.ofNullable(clazz.cast(this.fipsEnabled()));
            }
            case "CidrEndpointsCustomSubDomain": {
                return Optional.ofNullable(clazz.cast(this.cidrEndpointsCustomSubDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessInstanceRequest, T> g) {
        return obj -> g.apply((CreateVerifiedAccessInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean dryRun;
        private Boolean fipsEnabled;
        private String cidrEndpointsCustomSubDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessInstanceRequest model) {
            super(model);
            this.description(model.description);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.fipsEnabled(model.fipsEnabled);
            this.cidrEndpointsCustomSubDomain(model.cidrEndpointsCustomSubDomain);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getFipsEnabled() {
            return this.fipsEnabled;
        }

        public final void setFipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
        }

        @Override
        public final Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public final String getCidrEndpointsCustomSubDomain() {
            return this.cidrEndpointsCustomSubDomain;
        }

        public final void setCidrEndpointsCustomSubDomain(String cidrEndpointsCustomSubDomain) {
            this.cidrEndpointsCustomSubDomain = cidrEndpointsCustomSubDomain;
        }

        @Override
        public final Builder cidrEndpointsCustomSubDomain(String cidrEndpointsCustomSubDomain) {
            this.cidrEndpointsCustomSubDomain = cidrEndpointsCustomSubDomain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVerifiedAccessInstanceRequest build() {
            return new CreateVerifiedAccessInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessInstanceRequest> {
        public Builder description(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder fipsEnabled(Boolean var1);

        public Builder cidrEndpointsCustomSubDomain(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

