/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRangeListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessEndpointEniOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateVerifiedAccessEndpointEniOptions> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateVerifiedAccessEndpointEniOptions.getter(CreateVerifiedAccessEndpointEniOptions::networkInterfaceId)).setter(CreateVerifiedAccessEndpointEniOptions.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateVerifiedAccessEndpointEniOptions.getter(CreateVerifiedAccessEndpointEniOptions::protocolAsString)).setter(CreateVerifiedAccessEndpointEniOptions.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateVerifiedAccessEndpointEniOptions.getter(CreateVerifiedAccessEndpointEniOptions::port)).setter(CreateVerifiedAccessEndpointEniOptions.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("Port").build()}).build();
    private static final SdkField<List<CreateVerifiedAccessEndpointPortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(CreateVerifiedAccessEndpointEniOptions.getter(CreateVerifiedAccessEndpointEniOptions::portRanges)).setter(CreateVerifiedAccessEndpointEniOptions.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").unmarshallLocationName("PortRange").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateVerifiedAccessEndpointPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, PROTOCOL_FIELD, PORT_FIELD, PORT_RANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("PortRange", PORT_RANGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String networkInterfaceId;
    private final String protocol;
    private final Integer port;
    private final List<CreateVerifiedAccessEndpointPortRange> portRanges;

    private CreateVerifiedAccessEndpointEniOptions(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.portRanges = builder.portRanges;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<CreateVerifiedAccessEndpointPortRange> portRanges() {
        return this.portRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessEndpointEniOptions)) {
            return false;
        }
        CreateVerifiedAccessEndpointEniOptions other = (CreateVerifiedAccessEndpointEniOptions)obj;
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessEndpointEniOptions").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessEndpointEniOptions, T> g) {
        return obj -> g.apply((CreateVerifiedAccessEndpointEniOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String protocol;
        private Integer port;
        private List<CreateVerifiedAccessEndpointPortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessEndpointEniOptions model) {
            this.networkInterfaceId(model.networkInterfaceId);
            this.protocol(model.protocol);
            this.port(model.port);
            this.portRanges(model.portRanges);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final List<CreateVerifiedAccessEndpointPortRange.Builder> getPortRanges() {
            List<CreateVerifiedAccessEndpointPortRange.Builder> result = CreateVerifiedAccessEndpointPortRangeListCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<CreateVerifiedAccessEndpointPortRange.BuilderImpl> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(CreateVerifiedAccessEndpointPortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (CreateVerifiedAccessEndpointPortRange)((CreateVerifiedAccessEndpointPortRange.Builder)CreateVerifiedAccessEndpointPortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateVerifiedAccessEndpointEniOptions build() {
            return new CreateVerifiedAccessEndpointEniOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessEndpointEniOptions> {
        public Builder networkInterfaceId(String var1);

        public Builder protocol(String var1);

        public Builder protocol(VerifiedAccessEndpointProtocol var1);

        public Builder port(Integer var1);

        public Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> var1);

        public Builder portRanges(CreateVerifiedAccessEndpointPortRange ... var1);

        public Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder> ... var1);
    }
}

