/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRangeListCopier;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointSubnetIdListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessEndpointCidrOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateVerifiedAccessEndpointCidrOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(CreateVerifiedAccessEndpointCidrOptions.getter(CreateVerifiedAccessEndpointCidrOptions::protocolAsString)).setter(CreateVerifiedAccessEndpointCidrOptions.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateVerifiedAccessEndpointCidrOptions.getter(CreateVerifiedAccessEndpointCidrOptions::subnetIds)).setter(CreateVerifiedAccessEndpointCidrOptions.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(CreateVerifiedAccessEndpointCidrOptions.getter(CreateVerifiedAccessEndpointCidrOptions::cidr)).setter(CreateVerifiedAccessEndpointCidrOptions.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<List<CreateVerifiedAccessEndpointPortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(CreateVerifiedAccessEndpointCidrOptions.getter(CreateVerifiedAccessEndpointCidrOptions::portRanges)).setter(CreateVerifiedAccessEndpointCidrOptions.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").unmarshallLocationName("PortRange").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateVerifiedAccessEndpointPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, SUBNET_IDS_FIELD, CIDR_FIELD, PORT_RANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("SubnetId", SUBNET_IDS_FIELD);
            this.put("Cidr", CIDR_FIELD);
            this.put("PortRange", PORT_RANGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final List<String> subnetIds;
    private final String cidr;
    private final List<CreateVerifiedAccessEndpointPortRange> portRanges;

    private CreateVerifiedAccessEndpointCidrOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.subnetIds = builder.subnetIds;
        this.cidr = builder.cidr;
        this.portRanges = builder.portRanges;
    }

    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<CreateVerifiedAccessEndpointPortRange> portRanges() {
        return this.portRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessEndpointCidrOptions)) {
            return false;
        }
        CreateVerifiedAccessEndpointCidrOptions other = (CreateVerifiedAccessEndpointCidrOptions)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.cidr(), other.cidr()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessEndpointCidrOptions").add("Protocol", (Object)this.protocolAsString()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Cidr", (Object)this.cidr()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessEndpointCidrOptions, T> g) {
        return obj -> g.apply((CreateVerifiedAccessEndpointCidrOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String cidr;
        private List<CreateVerifiedAccessEndpointPortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessEndpointCidrOptions model) {
            this.protocol(model.protocol);
            this.subnetIds(model.subnetIds);
            this.cidr(model.cidr);
            this.portRanges(model.portRanges);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = CreateVerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = CreateVerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final List<CreateVerifiedAccessEndpointPortRange.Builder> getPortRanges() {
            List<CreateVerifiedAccessEndpointPortRange.Builder> result = CreateVerifiedAccessEndpointPortRangeListCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<CreateVerifiedAccessEndpointPortRange.BuilderImpl> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(CreateVerifiedAccessEndpointPortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (CreateVerifiedAccessEndpointPortRange)((CreateVerifiedAccessEndpointPortRange.Builder)CreateVerifiedAccessEndpointPortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateVerifiedAccessEndpointCidrOptions build() {
            return new CreateVerifiedAccessEndpointCidrOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessEndpointCidrOptions> {
        public Builder protocol(String var1);

        public Builder protocol(VerifiedAccessEndpointProtocol var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder cidr(String var1);

        public Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> var1);

        public Builder portRanges(CreateVerifiedAccessEndpointPortRange ... var1);

        public Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder> ... var1);
    }
}

