/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.MetricPoint;
import software.amazon.awssdk.services.ec2.model.MetricPointsCopier;
import software.amazon.awssdk.services.ec2.model.MetricType;
import software.amazon.awssdk.services.ec2.model.PeriodType;
import software.amazon.awssdk.services.ec2.model.StatisticType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DataResponse.getter(DataResponse::id)).setter(DataResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("id").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DataResponse.getter(DataResponse::source)).setter(DataResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(DataResponse.getter(DataResponse::destination)).setter(DataResponse.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("destination").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(DataResponse.getter(DataResponse::metricAsString)).setter(DataResponse.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").unmarshallLocationName("metric").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(DataResponse.getter(DataResponse::statisticAsString)).setter(DataResponse.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").unmarshallLocationName("statistic").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(DataResponse.getter(DataResponse::periodAsString)).setter(DataResponse.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").unmarshallLocationName("period").build()}).build();
    private static final SdkField<List<MetricPoint>> METRIC_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricPoints").getter(DataResponse.getter(DataResponse::metricPoints)).setter(DataResponse.setter(Builder::metricPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPointSet").unmarshallLocationName("metricPointSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SOURCE_FIELD, DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, PERIOD_FIELD, METRIC_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("Metric", METRIC_FIELD);
            this.put("Statistic", STATISTIC_FIELD);
            this.put("Period", PERIOD_FIELD);
            this.put("MetricPointSet", METRIC_POINTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String source;
    private final String destination;
    private final String metric;
    private final String statistic;
    private final String period;
    private final List<MetricPoint> metricPoints;

    private DataResponse(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.period = builder.period;
        this.metricPoints = builder.metricPoints;
    }

    public final String id() {
        return this.id;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final MetricType metric() {
        return MetricType.fromValue(this.metric);
    }

    public final String metricAsString() {
        return this.metric;
    }

    public final StatisticType statistic() {
        return StatisticType.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final PeriodType period() {
        return PeriodType.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final boolean hasMetricPoints() {
        return this.metricPoints != null && !(this.metricPoints instanceof SdkAutoConstructList);
    }

    public final List<MetricPoint> metricPoints() {
        return this.metricPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricPoints() ? this.metricPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataResponse)) {
            return false;
        }
        DataResponse other = (DataResponse)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.metricAsString(), other.metricAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && this.hasMetricPoints() == other.hasMetricPoints() && Objects.equals(this.metricPoints(), other.metricPoints());
    }

    public final String toString() {
        return ToString.builder((String)"DataResponse").add("Id", (Object)this.id()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("Metric", (Object)this.metricAsString()).add("Statistic", (Object)this.statisticAsString()).add("Period", (Object)this.periodAsString()).add("MetricPoints", this.hasMetricPoints() ? this.metricPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "MetricPoints": {
                return Optional.ofNullable(clazz.cast(this.metricPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataResponse, T> g) {
        return obj -> g.apply((DataResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String source;
        private String destination;
        private String metric;
        private String statistic;
        private String period;
        private List<MetricPoint> metricPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataResponse model) {
            this.id(model.id);
            this.source(model.source);
            this.destination(model.destination);
            this.metric(model.metric);
            this.statistic(model.statistic);
            this.period(model.period);
            this.metricPoints(model.metricPoints);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(PeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final List<MetricPoint.Builder> getMetricPoints() {
            List<MetricPoint.Builder> result = MetricPointsCopier.copyToBuilder(this.metricPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricPoints(Collection<MetricPoint.BuilderImpl> metricPoints) {
            this.metricPoints = MetricPointsCopier.copyFromBuilder(metricPoints);
        }

        @Override
        public final Builder metricPoints(Collection<MetricPoint> metricPoints) {
            this.metricPoints = MetricPointsCopier.copy(metricPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPoints(MetricPoint ... metricPoints) {
            this.metricPoints(Arrays.asList(metricPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricPoints(Consumer<MetricPoint.Builder> ... metricPoints) {
            this.metricPoints(Stream.of(metricPoints).map(c -> (MetricPoint)((MetricPoint.Builder)MetricPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataResponse build() {
            return new DataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataResponse> {
        public Builder id(String var1);

        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder metric(String var1);

        public Builder metric(MetricType var1);

        public Builder statistic(String var1);

        public Builder statistic(StatisticType var1);

        public Builder period(String var1);

        public Builder period(PeriodType var1);

        public Builder metricPoints(Collection<MetricPoint> var1);

        public Builder metricPoints(MetricPoint ... var1);

        public Builder metricPoints(Consumer<MetricPoint.Builder> ... var1);
    }
}

