/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequestOptions;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayConnectRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayConnectRequest> {
    private static final SdkField<String> TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransportTransitGatewayAttachmentId").getter(CreateTransitGatewayConnectRequest.getter(CreateTransitGatewayConnectRequest::transportTransitGatewayAttachmentId)).setter(CreateTransitGatewayConnectRequest.setter(Builder::transportTransitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportTransitGatewayAttachmentId").unmarshallLocationName("TransportTransitGatewayAttachmentId").build()}).build();
    private static final SdkField<CreateTransitGatewayConnectRequestOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(CreateTransitGatewayConnectRequest.getter(CreateTransitGatewayConnectRequest::options)).setter(CreateTransitGatewayConnectRequest.setter(Builder::options)).constructor(CreateTransitGatewayConnectRequestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("Options").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTransitGatewayConnectRequest.getter(CreateTransitGatewayConnectRequest::tagSpecifications)).setter(CreateTransitGatewayConnectRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateTransitGatewayConnectRequest.getter(CreateTransitGatewayConnectRequest::dryRun)).setter(CreateTransitGatewayConnectRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, OPTIONS_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransportTransitGatewayAttachmentId", TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String transportTransitGatewayAttachmentId;
    private final CreateTransitGatewayConnectRequestOptions options;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;

    private CreateTransitGatewayConnectRequest(BuilderImpl builder) {
        super(builder);
        this.transportTransitGatewayAttachmentId = builder.transportTransitGatewayAttachmentId;
        this.options = builder.options;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    public final String transportTransitGatewayAttachmentId() {
        return this.transportTransitGatewayAttachmentId;
    }

    public final CreateTransitGatewayConnectRequestOptions options() {
        return this.options;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transportTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayConnectRequest)) {
            return false;
        }
        CreateTransitGatewayConnectRequest other = (CreateTransitGatewayConnectRequest)((Object)obj);
        return Objects.equals(this.transportTransitGatewayAttachmentId(), other.transportTransitGatewayAttachmentId()) && Objects.equals(this.options(), other.options()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayConnectRequest").add("TransportTransitGatewayAttachmentId", (Object)this.transportTransitGatewayAttachmentId()).add("Options", (Object)this.options()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransportTransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transportTransitGatewayAttachmentId()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayConnectRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayConnectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transportTransitGatewayAttachmentId;
        private CreateTransitGatewayConnectRequestOptions options;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayConnectRequest model) {
            super(model);
            this.transportTransitGatewayAttachmentId(model.transportTransitGatewayAttachmentId);
            this.options(model.options);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
        }

        public final String getTransportTransitGatewayAttachmentId() {
            return this.transportTransitGatewayAttachmentId;
        }

        public final void setTransportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
        }

        @Override
        public final Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        public final CreateTransitGatewayConnectRequestOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(CreateTransitGatewayConnectRequestOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(CreateTransitGatewayConnectRequestOptions options) {
            this.options = options;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayConnectRequest build() {
            return new CreateTransitGatewayConnectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayConnectRequest> {
        public Builder transportTransitGatewayAttachmentId(String var1);

        public Builder options(CreateTransitGatewayConnectRequestOptions var1);

        default public Builder options(Consumer<CreateTransitGatewayConnectRequestOptions.Builder> options) {
            return this.options((CreateTransitGatewayConnectRequestOptions)((CreateTransitGatewayConnectRequestOptions.Builder)CreateTransitGatewayConnectRequestOptions.builder().applyMutation(options)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

