/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AccessScopePath;
import software.amazon.awssdk.services.ec2.model.AccessScopePathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInsightsAccessScopeContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInsightsAccessScopeContent> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeId").getter(NetworkInsightsAccessScopeContent.getter(NetworkInsightsAccessScopeContent::networkInsightsAccessScopeId)).setter(NetworkInsightsAccessScopeContent.setter(Builder::networkInsightsAccessScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("networkInsightsAccessScopeId").build()}).build();
    private static final SdkField<List<AccessScopePath>> MATCH_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchPaths").getter(NetworkInsightsAccessScopeContent.getter(NetworkInsightsAccessScopeContent::matchPaths)).setter(NetworkInsightsAccessScopeContent.setter(Builder::matchPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPathSet").unmarshallLocationName("matchPathSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessScopePath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<AccessScopePath>> EXCLUDE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludePaths").getter(NetworkInsightsAccessScopeContent.getter(NetworkInsightsAccessScopeContent::excludePaths)).setter(NetworkInsightsAccessScopeContent.setter(Builder::excludePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePathSet").unmarshallLocationName("excludePathSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessScopePath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, MATCH_PATHS_FIELD, EXCLUDE_PATHS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkInsightsAccessScopeId", NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD);
            this.put("MatchPathSet", MATCH_PATHS_FIELD);
            this.put("ExcludePathSet", EXCLUDE_PATHS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String networkInsightsAccessScopeId;
    private final List<AccessScopePath> matchPaths;
    private final List<AccessScopePath> excludePaths;

    private NetworkInsightsAccessScopeContent(BuilderImpl builder) {
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.matchPaths = builder.matchPaths;
        this.excludePaths = builder.excludePaths;
    }

    public final String networkInsightsAccessScopeId() {
        return this.networkInsightsAccessScopeId;
    }

    public final boolean hasMatchPaths() {
        return this.matchPaths != null && !(this.matchPaths instanceof SdkAutoConstructList);
    }

    public final List<AccessScopePath> matchPaths() {
        return this.matchPaths;
    }

    public final boolean hasExcludePaths() {
        return this.excludePaths != null && !(this.excludePaths instanceof SdkAutoConstructList);
    }

    public final List<AccessScopePath> excludePaths() {
        return this.excludePaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchPaths() ? this.matchPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludePaths() ? this.excludePaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAccessScopeContent)) {
            return false;
        }
        NetworkInsightsAccessScopeContent other = (NetworkInsightsAccessScopeContent)obj;
        return Objects.equals(this.networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId()) && this.hasMatchPaths() == other.hasMatchPaths() && Objects.equals(this.matchPaths(), other.matchPaths()) && this.hasExcludePaths() == other.hasExcludePaths() && Objects.equals(this.excludePaths(), other.excludePaths());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInsightsAccessScopeContent").add("NetworkInsightsAccessScopeId", (Object)this.networkInsightsAccessScopeId()).add("MatchPaths", this.hasMatchPaths() ? this.matchPaths() : null).add("ExcludePaths", this.hasExcludePaths() ? this.excludePaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeId()));
            }
            case "MatchPaths": {
                return Optional.ofNullable(clazz.cast(this.matchPaths()));
            }
            case "ExcludePaths": {
                return Optional.ofNullable(clazz.cast(this.excludePaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAccessScopeContent, T> g) {
        return obj -> g.apply((NetworkInsightsAccessScopeContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsAccessScopeId;
        private List<AccessScopePath> matchPaths = DefaultSdkAutoConstructList.getInstance();
        private List<AccessScopePath> excludePaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAccessScopeContent model) {
            this.networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            this.matchPaths(model.matchPaths);
            this.excludePaths(model.excludePaths);
        }

        public final String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final List<AccessScopePath.Builder> getMatchPaths() {
            List<AccessScopePath.Builder> result = AccessScopePathListCopier.copyToBuilder(this.matchPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchPaths(Collection<AccessScopePath.BuilderImpl> matchPaths) {
            this.matchPaths = AccessScopePathListCopier.copyFromBuilder(matchPaths);
        }

        @Override
        public final Builder matchPaths(Collection<AccessScopePath> matchPaths) {
            this.matchPaths = AccessScopePathListCopier.copy(matchPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPaths(AccessScopePath ... matchPaths) {
            this.matchPaths(Arrays.asList(matchPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPaths(Consumer<AccessScopePath.Builder> ... matchPaths) {
            this.matchPaths(Stream.of(matchPaths).map(c -> (AccessScopePath)((AccessScopePath.Builder)AccessScopePath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccessScopePath.Builder> getExcludePaths() {
            List<AccessScopePath.Builder> result = AccessScopePathListCopier.copyToBuilder(this.excludePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludePaths(Collection<AccessScopePath.BuilderImpl> excludePaths) {
            this.excludePaths = AccessScopePathListCopier.copyFromBuilder(excludePaths);
        }

        @Override
        public final Builder excludePaths(Collection<AccessScopePath> excludePaths) {
            this.excludePaths = AccessScopePathListCopier.copy(excludePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludePaths(AccessScopePath ... excludePaths) {
            this.excludePaths(Arrays.asList(excludePaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludePaths(Consumer<AccessScopePath.Builder> ... excludePaths) {
            this.excludePaths(Stream.of(excludePaths).map(c -> (AccessScopePath)((AccessScopePath.Builder)AccessScopePath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkInsightsAccessScopeContent build() {
            return new NetworkInsightsAccessScopeContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInsightsAccessScopeContent> {
        public Builder networkInsightsAccessScopeId(String var1);

        public Builder matchPaths(Collection<AccessScopePath> var1);

        public Builder matchPaths(AccessScopePath ... var1);

        public Builder matchPaths(Consumer<AccessScopePath.Builder> ... var1);

        public Builder excludePaths(Collection<AccessScopePath> var1);

        public Builder excludePaths(AccessScopePath ... var1);

        public Builder excludePaths(Consumer<AccessScopePath.Builder> ... var1);
    }
}

