/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The BGP options for the Connect attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConnectRequestBgpOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConnectRequestBgpOptions.Builder, TransitGatewayConnectRequestBgpOptions> {
    private static final SdkField<Long> PEER_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerAsn")
            .getter(getter(TransitGatewayConnectRequestBgpOptions::peerAsn))
            .setter(setter(Builder::peerAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn")
                    .unmarshallLocationName("PeerAsn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_ASN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PeerAsn", PEER_ASN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long peerAsn;

    private TransitGatewayConnectRequestBgpOptions(BuilderImpl builder) {
        this.peerAsn = builder.peerAsn;
    }

    /**
     * <p>
     * The peer Autonomous System Number (ASN).
     * </p>
     * 
     * @return The peer Autonomous System Number (ASN).
     */
    public final Long peerAsn() {
        return peerAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peerAsn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectRequestBgpOptions)) {
            return false;
        }
        TransitGatewayConnectRequestBgpOptions other = (TransitGatewayConnectRequestBgpOptions) obj;
        return Objects.equals(peerAsn(), other.peerAsn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayConnectRequestBgpOptions").add("PeerAsn", peerAsn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerAsn":
            return Optional.ofNullable(clazz.cast(peerAsn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectRequestBgpOptions, T> g) {
        return obj -> g.apply((TransitGatewayConnectRequestBgpOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConnectRequestBgpOptions> {
        /**
         * <p>
         * The peer Autonomous System Number (ASN).
         * </p>
         * 
         * @param peerAsn
         *        The peer Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAsn(Long peerAsn);
    }

    static final class BuilderImpl implements Builder {
        private Long peerAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectRequestBgpOptions model) {
            peerAsn(model.peerAsn);
        }

        public final Long getPeerAsn() {
            return peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        @Override
        public TransitGatewayConnectRequestBgpOptions build() {
            return new TransitGatewayConnectRequestBgpOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
