/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreSnapshotTierRequest extends Ec2Request implements
        ToCopyableBuilder<RestoreSnapshotTierRequest.Builder, RestoreSnapshotTierRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(RestoreSnapshotTierRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<Integer> TEMPORARY_RESTORE_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TemporaryRestoreDays")
            .getter(getter(RestoreSnapshotTierRequest::temporaryRestoreDays))
            .setter(setter(Builder::temporaryRestoreDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryRestoreDays")
                    .unmarshallLocationName("TemporaryRestoreDays").build()).build();

    private static final SdkField<Boolean> PERMANENT_RESTORE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PermanentRestore")
            .getter(getter(RestoreSnapshotTierRequest::permanentRestore))
            .setter(setter(Builder::permanentRestore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermanentRestore")
                    .unmarshallLocationName("PermanentRestore").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RestoreSnapshotTierRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            TEMPORARY_RESTORE_DAYS_FIELD, PERMANENT_RESTORE_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SnapshotId", SNAPSHOT_ID_FIELD);
                    put("TemporaryRestoreDays", TEMPORARY_RESTORE_DAYS_FIELD);
                    put("PermanentRestore", PERMANENT_RESTORE_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String snapshotId;

    private final Integer temporaryRestoreDays;

    private final Boolean permanentRestore;

    private final Boolean dryRun;

    private RestoreSnapshotTierRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.temporaryRestoreDays = builder.temporaryRestoreDays;
        this.permanentRestore = builder.permanentRestore;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the snapshot to restore.
     * </p>
     * 
     * @return The ID of the snapshot to restore.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary
     * restores only. The snapshot will be automatically re-archived after this period.
     * </p>
     * <p>
     * To temporarily restore an archived snapshot, specify the number of days and omit the <b>PermanentRestore</b>
     * parameter or set it to <code>false</code>.
     * </p>
     * 
     * @return Specifies the number of days for which to temporarily restore an archived snapshot. Required for
     *         temporary restores only. The snapshot will be automatically re-archived after this period.</p>
     *         <p>
     *         To temporarily restore an archived snapshot, specify the number of days and omit the
     *         <b>PermanentRestore</b> parameter or set it to <code>false</code>.
     */
    public final Integer temporaryRestoreDays() {
        return temporaryRestoreDays;
    }

    /**
     * <p>
     * Indicates whether to permanently restore an archived snapshot. To permanently restore an archived snapshot,
     * specify <code>true</code> and omit the <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.
     * </p>
     * 
     * @return Indicates whether to permanently restore an archived snapshot. To permanently restore an archived
     *         snapshot, specify <code>true</code> and omit the <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b>
     *         parameter.
     */
    public final Boolean permanentRestore() {
        return permanentRestore;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(temporaryRestoreDays());
        hashCode = 31 * hashCode + Objects.hashCode(permanentRestore());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSnapshotTierRequest)) {
            return false;
        }
        RestoreSnapshotTierRequest other = (RestoreSnapshotTierRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(temporaryRestoreDays(), other.temporaryRestoreDays())
                && Objects.equals(permanentRestore(), other.permanentRestore()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreSnapshotTierRequest").add("SnapshotId", snapshotId())
                .add("TemporaryRestoreDays", temporaryRestoreDays()).add("PermanentRestore", permanentRestore())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "TemporaryRestoreDays":
            return Optional.ofNullable(clazz.cast(temporaryRestoreDays()));
        case "PermanentRestore":
            return Optional.ofNullable(clazz.cast(permanentRestore()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RestoreSnapshotTierRequest, T> g) {
        return obj -> g.apply((RestoreSnapshotTierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RestoreSnapshotTierRequest> {
        /**
         * <p>
         * The ID of the snapshot to restore.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot to restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary
         * restores only. The snapshot will be automatically re-archived after this period.
         * </p>
         * <p>
         * To temporarily restore an archived snapshot, specify the number of days and omit the <b>PermanentRestore</b>
         * parameter or set it to <code>false</code>.
         * </p>
         * 
         * @param temporaryRestoreDays
         *        Specifies the number of days for which to temporarily restore an archived snapshot. Required for
         *        temporary restores only. The snapshot will be automatically re-archived after this period.</p>
         *        <p>
         *        To temporarily restore an archived snapshot, specify the number of days and omit the
         *        <b>PermanentRestore</b> parameter or set it to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryRestoreDays(Integer temporaryRestoreDays);

        /**
         * <p>
         * Indicates whether to permanently restore an archived snapshot. To permanently restore an archived snapshot,
         * specify <code>true</code> and omit the <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.
         * </p>
         * 
         * @param permanentRestore
         *        Indicates whether to permanently restore an archived snapshot. To permanently restore an archived
         *        snapshot, specify <code>true</code> and omit the
         *        <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permanentRestore(Boolean permanentRestore);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String snapshotId;

        private Integer temporaryRestoreDays;

        private Boolean permanentRestore;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSnapshotTierRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            temporaryRestoreDays(model.temporaryRestoreDays);
            permanentRestore(model.permanentRestore);
            dryRun(model.dryRun);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getTemporaryRestoreDays() {
            return temporaryRestoreDays;
        }

        public final void setTemporaryRestoreDays(Integer temporaryRestoreDays) {
            this.temporaryRestoreDays = temporaryRestoreDays;
        }

        @Override
        public final Builder temporaryRestoreDays(Integer temporaryRestoreDays) {
            this.temporaryRestoreDays = temporaryRestoreDays;
            return this;
        }

        public final Boolean getPermanentRestore() {
            return permanentRestore;
        }

        public final void setPermanentRestore(Boolean permanentRestore) {
            this.permanentRestore = permanentRestore;
        }

        @Override
        public final Builder permanentRestore(Boolean permanentRestore) {
            this.permanentRestore = permanentRestore;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreSnapshotTierRequest build() {
            return new RestoreSnapshotTierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
