/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstances implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstances.Builder, ReservedInstances> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(ReservedInstances::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceTenancy")
            .getter(getter(ReservedInstances::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("instanceTenancy").build()).build();

    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingClass")
            .getter(getter(ReservedInstances::offeringClassAsString))
            .setter(setter(Builder::offeringClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass")
                    .unmarshallLocationName("offeringClass").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingType")
            .getter(getter(ReservedInstances::offeringTypeAsString))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType")
                    .unmarshallLocationName("offeringType").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedInstances::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges")
                    .unmarshallLocationName("recurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Scope")
            .getter(getter(ReservedInstances::scopeAsString))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("scope").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ReservedInstances::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesId")
            .getter(getter(ReservedInstances::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ReservedInstances::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ReservedInstances::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Instant> START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Start")
            .getter(getter(ReservedInstances::start))
            .setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start")
                    .unmarshallLocationName("start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("End")
            .getter(getter(ReservedInstances::end))
            .setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").unmarshallLocationName("end")
                    .build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Duration")
            .getter(getter(ReservedInstances::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<Float> USAGE_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("UsagePrice")
            .getter(getter(ReservedInstances::usagePrice))
            .setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice")
                    .unmarshallLocationName("usagePrice").build()).build();

    private static final SdkField<Float> FIXED_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("FixedPrice")
            .getter(getter(ReservedInstances::fixedPrice))
            .setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice")
                    .unmarshallLocationName("fixedPrice").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(ReservedInstances::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription")
            .getter(getter(ReservedInstances::productDescriptionAsString))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription")
                    .unmarshallLocationName("productDescription").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(ReservedInstances::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            INSTANCE_TENANCY_FIELD, OFFERING_CLASS_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD, SCOPE_FIELD, TAGS_FIELD,
            RESERVED_INSTANCES_ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, START_FIELD, END_FIELD, DURATION_FIELD,
            USAGE_PRICE_FIELD, FIXED_PRICE_FIELD, INSTANCE_COUNT_FIELD, PRODUCT_DESCRIPTION_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CurrencyCode", CURRENCY_CODE_FIELD);
                    put("InstanceTenancy", INSTANCE_TENANCY_FIELD);
                    put("OfferingClass", OFFERING_CLASS_FIELD);
                    put("OfferingType", OFFERING_TYPE_FIELD);
                    put("RecurringCharges", RECURRING_CHARGES_FIELD);
                    put("Scope", SCOPE_FIELD);
                    put("TagSet", TAGS_FIELD);
                    put("ReservedInstancesId", RESERVED_INSTANCES_ID_FIELD);
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
                    put("Start", START_FIELD);
                    put("End", END_FIELD);
                    put("Duration", DURATION_FIELD);
                    put("UsagePrice", USAGE_PRICE_FIELD);
                    put("FixedPrice", FIXED_PRICE_FIELD);
                    put("InstanceCount", INSTANCE_COUNT_FIELD);
                    put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
                    put("State", STATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final String instanceTenancy;

    private final String offeringClass;

    private final String offeringType;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private final List<Tag> tags;

    private final String reservedInstancesId;

    private final String instanceType;

    private final String availabilityZone;

    private final Instant start;

    private final Instant end;

    private final Long duration;

    private final Float usagePrice;

    private final Float fixedPrice;

    private final Integer instanceCount;

    private final String productDescription;

    private final String state;

    private ReservedInstances(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.start = builder.start;
        this.end = builder.end;
        this.duration = builder.duration;
        this.usagePrice = builder.usagePrice;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.productDescription = builder.productDescription;
        this.state = builder.state;
    }

    /**
     * <p>
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time, the
     * only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
     *         time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time, the
     * only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
     *         time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public final String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The offering class of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance.
     * @see OfferingClassType
     */
    public final OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * The offering class of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance.
     * @see OfferingClassType
     */
    public final String offeringClassAsString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public final OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public final String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * The scope of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the Reserved Instance.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the Reserved Instance.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public final String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The date and time the Reserved Instance started.
     * </p>
     * 
     * @return The date and time the Reserved Instance started.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The time when the Reserved Instance expires.
     * </p>
     * 
     * @return The time when the Reserved Instance expires.
     */
    public final Instant end() {
        return end;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public final Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public final Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The number of reservations purchased.
     * </p>
     * 
     * @return The number of reservations purchased.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public final String productDescriptionAsString() {
        return productDescription;
    }

    /**
     * <p>
     * The state of the Reserved Instance purchase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservedInstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Reserved Instance purchase.
     * @see ReservedInstanceState
     */
    public final ReservedInstanceState state() {
        return ReservedInstanceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Reserved Instance purchase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservedInstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Reserved Instance purchase.
     * @see ReservedInstanceState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances) obj;
        return Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && Objects.equals(offeringClassAsString(), other.offeringClassAsString())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(scopeAsString(), other.scopeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end()) && Objects.equals(duration(), other.duration())
                && Objects.equals(usagePrice(), other.usagePrice()) && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(productDescriptionAsString(), other.productDescriptionAsString())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstances").add("CurrencyCode", currencyCodeAsString())
                .add("InstanceTenancy", instanceTenancyAsString()).add("OfferingClass", offeringClassAsString())
                .add("OfferingType", offeringTypeAsString())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).add("Scope", scopeAsString())
                .add("Tags", hasTags() ? tags() : null).add("ReservedInstancesId", reservedInstancesId())
                .add("InstanceType", instanceTypeAsString()).add("AvailabilityZone", availabilityZone()).add("Start", start())
                .add("End", end()).add("Duration", duration()).add("UsagePrice", usagePrice()).add("FixedPrice", fixedPrice())
                .add("InstanceCount", instanceCount()).add("ProductDescription", productDescriptionAsString())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        case "OfferingClass":
            return Optional.ofNullable(clazz.cast(offeringClassAsString()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescriptionAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstances, T> g) {
        return obj -> g.apply((ReservedInstances) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstances> {
        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RecurringCharge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RecurringCharge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(java.util.Collection<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The date and time the Reserved Instance started.
         * </p>
         * 
         * @param start
         *        The date and time the Reserved Instance started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The time when the Reserved Instance expires.
         * </p>
         * 
         * @param end
         *        The time when the Reserved Instance expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The number of reservations purchased.
         * </p>
         * 
         * @param instanceCount
         *        The number of reservations purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(ReservedInstanceState state);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private String instanceTenancy;

        private String offeringClass;

        private String offeringType;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String reservedInstancesId;

        private String instanceType;

        private String availabilityZone;

        private Instant start;

        private Instant end;

        private Long duration;

        private Float usagePrice;

        private Float fixedPrice;

        private Integer instanceCount;

        private String productDescription;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            currencyCode(model.currencyCode);
            instanceTenancy(model.instanceTenancy);
            offeringClass(model.offeringClass);
            offeringType(model.offeringType);
            recurringCharges(model.recurringCharges);
            scope(model.scope);
            tags(model.tags);
            reservedInstancesId(model.reservedInstancesId);
            instanceType(model.instanceType);
            availabilityZone(model.availabilityZone);
            start(model.start);
            end(model.end);
            duration(model.duration);
            usagePrice(model.usagePrice);
            fixedPrice(model.fixedPrice);
            instanceCount(model.instanceCount);
            productDescription(model.productDescription);
            state(model.state);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargesListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public ReservedInstances build() {
            return new ReservedInstances(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
