/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceNetworkAclEntryRequest extends Ec2Request implements
        ToCopyableBuilder<ReplaceNetworkAclEntryRequest.Builder, ReplaceNetworkAclEntryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ReplaceNetworkAclEntryRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclId")
            .getter(getter(ReplaceNetworkAclEntryRequest::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId")
                    .unmarshallLocationName("networkAclId").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(ReplaceNetworkAclEntryRequest::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(ReplaceNetworkAclEntryRequest::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(ReplaceNetworkAclEntryRequest::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<Boolean> EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Egress")
            .getter(getter(ReplaceNetworkAclEntryRequest::egress))
            .setter(setter(Builder::egress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress")
                    .unmarshallLocationName("egress").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(ReplaceNetworkAclEntryRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(ReplaceNetworkAclEntryRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("ipv6CidrBlock").build()).build();

    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField
            .<IcmpTypeCode> builder(MarshallingType.SDK_POJO)
            .memberName("IcmpTypeCode")
            .getter(getter(ReplaceNetworkAclEntryRequest::icmpTypeCode))
            .setter(setter(Builder::icmpTypeCode))
            .constructor(IcmpTypeCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icmp")
                    .unmarshallLocationName("Icmp").build()).build();

    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField
            .<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("PortRange")
            .getter(getter(ReplaceNetworkAclEntryRequest::portRange))
            .setter(setter(Builder::portRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange")
                    .unmarshallLocationName("portRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            NETWORK_ACL_ID_FIELD, RULE_NUMBER_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, EGRESS_FIELD, CIDR_BLOCK_FIELD,
            IPV6_CIDR_BLOCK_FIELD, ICMP_TYPE_CODE_FIELD, PORT_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("NetworkAclId", NETWORK_ACL_ID_FIELD);
                    put("RuleNumber", RULE_NUMBER_FIELD);
                    put("Protocol", PROTOCOL_FIELD);
                    put("RuleAction", RULE_ACTION_FIELD);
                    put("Egress", EGRESS_FIELD);
                    put("CidrBlock", CIDR_BLOCK_FIELD);
                    put("Ipv6CidrBlock", IPV6_CIDR_BLOCK_FIELD);
                    put("Icmp", ICMP_TYPE_CODE_FIELD);
                    put("PortRange", PORT_RANGE_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String networkAclId;

    private final Integer ruleNumber;

    private final String protocol;

    private final String ruleAction;

    private final Boolean egress;

    private final String cidrBlock;

    private final String ipv6CidrBlock;

    private final IcmpTypeCode icmpTypeCode;

    private final PortRange portRange;

    private ReplaceNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.networkAclId = builder.networkAclId;
        this.ruleNumber = builder.ruleNumber;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.egress = builder.egress;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.portRange = builder.portRange;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the ACL.
     * </p>
     * 
     * @return The ID of the ACL.
     */
    public final String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The rule number of the entry to replace.
     * </p>
     * 
     * @return The rule number of the entry to replace.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6"
     * (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes
     * that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP
     * types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an
     * IPv6 CIDR block, you must specify an ICMP type and code.
     * </p>
     * 
     * @return The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other
     *         than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
     *         ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
     *         block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify
     *         protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public final RuleAction ruleAction() {
        return RuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public final String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * Indicates whether to replace the egress rule.
     * </p>
     * <p>
     * Default: If no value is specified, we replace the ingress rule.
     * </p>
     * 
     * @return Indicates whether to replace the egress rule.</p>
     *         <p>
     *         Default: If no value is specified, we replace the ingress rule.
     */
    public final Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     * </p>
     * 
     * @return The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:bd8:1234:1a00::/64</code>).
     * </p>
     * 
     * @return The IPv6 network range to allow or deny, in CIDR notation (for example
     *         <code>2001:bd8:1234:1a00::/64</code>).
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6)
     * with an IPv6 CIDR block.
     * </p>
     * 
     * @return ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
     *         (ICMPv6) with an IPv6 CIDR block.
     */
    public final IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
     * (UDP).
     * </p>
     * 
     * @return TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or
     *         17 (UDP).
     */
    public final PortRange portRange() {
        return portRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclEntryRequest)) {
            return false;
        }
        ReplaceNetworkAclEntryRequest other = (ReplaceNetworkAclEntryRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(networkAclId(), other.networkAclId())
                && Objects.equals(ruleNumber(), other.ruleNumber()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(egress(), other.egress())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(portRange(), other.portRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceNetworkAclEntryRequest").add("DryRun", dryRun()).add("NetworkAclId", networkAclId())
                .add("RuleNumber", ruleNumber()).add("Protocol", protocol()).add("RuleAction", ruleActionAsString())
                .add("Egress", egress()).add("CidrBlock", cidrBlock()).add("Ipv6CidrBlock", ipv6CidrBlock())
                .add("IcmpTypeCode", icmpTypeCode()).add("PortRange", portRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "IcmpTypeCode":
            return Optional.ofNullable(clazz.cast(icmpTypeCode()));
        case "PortRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclEntryRequest, T> g) {
        return obj -> g.apply((ReplaceNetworkAclEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceNetworkAclEntryRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The rule number of the entry to replace.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the entry to replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than
         * "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types
         * or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
         * all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
         * and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         * </p>
         * 
         * @param protocol
         *        The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number
         *        other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any
         *        ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an
         *        IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If
         *        you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(RuleAction ruleAction);

        /**
         * <p>
         * Indicates whether to replace the egress rule.
         * </p>
         * <p>
         * Default: If no value is specified, we replace the ingress rule.
         * </p>
         * 
         * @param egress
         *        Indicates whether to replace the egress rule.</p>
         *        <p>
         *        Default: If no value is specified, we replace the ingress rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:bd8:1234:1a00::/64</code>).
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range to allow or deny, in CIDR notation (for example
         *        <code>2001:bd8:1234:1a00::/64</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
         * (ICMPv6) with an IPv6 CIDR block.
         * </p>
         * 
         * @param icmpTypeCode
         *        ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol
         *        58 (ICMPv6) with an IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
         * (ICMPv6) with an IPv6 CIDR block.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcmpTypeCode.Builder} avoiding the need
         * to create one manually via {@link IcmpTypeCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcmpTypeCode.Builder#build()} is called immediately and its
         * result is passed to {@link #icmpTypeCode(IcmpTypeCode)}.
         * 
         * @param icmpTypeCode
         *        a consumer that will call methods on {@link IcmpTypeCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icmpTypeCode(IcmpTypeCode)
         */
        default Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return icmpTypeCode(IcmpTypeCode.builder().applyMutation(icmpTypeCode).build());
        }

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
         * (UDP).
         * </p>
         * 
         * @param portRange
         *        TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP)
         *        or 17 (UDP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
         * (UDP).
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRange.Builder} avoiding the need to
         * create one manually via {@link PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #portRange(PortRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRange)
         */
        default Builder portRange(Consumer<PortRange.Builder> portRange) {
            return portRange(PortRange.builder().applyMutation(portRange).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String networkAclId;

        private Integer ruleNumber;

        private String protocol;

        private String ruleAction;

        private Boolean egress;

        private String cidrBlock;

        private String ipv6CidrBlock;

        private IcmpTypeCode icmpTypeCode;

        private PortRange portRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclEntryRequest model) {
            super(model);
            dryRun(model.dryRun);
            networkAclId(model.networkAclId);
            ruleNumber(model.ruleNumber);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            egress(model.egress);
            cidrBlock(model.cidrBlock);
            ipv6CidrBlock(model.ipv6CidrBlock);
            icmpTypeCode(model.icmpTypeCode);
            portRange(model.portRange);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final Boolean getEgress() {
            return egress;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return icmpTypeCode != null ? icmpTypeCode.toBuilder() : null;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceNetworkAclEntryRequest build() {
            return new ReplaceNetworkAclEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
