/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved. If you need to sustain traffic greater than the <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-gateways">documented
 * limits</a>, contact Amazon Web Services Support.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedBandwidth implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedBandwidth.Builder, ProvisionedBandwidth> {
    private static final SdkField<Instant> PROVISION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ProvisionTime")
            .getter(getter(ProvisionedBandwidth::provisionTime))
            .setter(setter(Builder::provisionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionTime")
                    .unmarshallLocationName("provisionTime").build()).build();

    private static final SdkField<String> PROVISIONED_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Provisioned")
            .getter(getter(ProvisionedBandwidth::provisioned))
            .setter(setter(Builder::provisioned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provisioned")
                    .unmarshallLocationName("provisioned").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTime")
            .getter(getter(ProvisionedBandwidth::requestTime))
            .setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime")
                    .unmarshallLocationName("requestTime").build()).build();

    private static final SdkField<String> REQUESTED_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Requested")
            .getter(getter(ProvisionedBandwidth::requested))
            .setter(setter(Builder::requested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requested")
                    .unmarshallLocationName("requested").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ProvisionedBandwidth::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_TIME_FIELD,
            PROVISIONED_FIELD, REQUEST_TIME_FIELD, REQUESTED_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProvisionTime", PROVISION_TIME_FIELD);
                    put("Provisioned", PROVISIONED_FIELD);
                    put("RequestTime", REQUEST_TIME_FIELD);
                    put("Requested", REQUESTED_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant provisionTime;

    private final String provisioned;

    private final Instant requestTime;

    private final String requested;

    private final String status;

    private ProvisionedBandwidth(BuilderImpl builder) {
        this.provisionTime = builder.provisionTime;
        this.provisioned = builder.provisioned;
        this.requestTime = builder.requestTime;
        this.requested = builder.requested;
        this.status = builder.status;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final Instant provisionTime() {
        return provisionTime;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String provisioned() {
        return provisioned;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String requested() {
        return requested;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisionTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(requested());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedBandwidth)) {
            return false;
        }
        ProvisionedBandwidth other = (ProvisionedBandwidth) obj;
        return Objects.equals(provisionTime(), other.provisionTime()) && Objects.equals(provisioned(), other.provisioned())
                && Objects.equals(requestTime(), other.requestTime()) && Objects.equals(requested(), other.requested())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedBandwidth").add("ProvisionTime", provisionTime()).add("Provisioned", provisioned())
                .add("RequestTime", requestTime()).add("Requested", requested()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionTime":
            return Optional.ofNullable(clazz.cast(provisionTime()));
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "Requested":
            return Optional.ofNullable(clazz.cast(requested()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedBandwidth, T> g) {
        return obj -> g.apply((ProvisionedBandwidth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedBandwidth> {
        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param provisionTime
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionTime(Instant provisionTime);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param provisioned
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(String provisioned);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param requestTime
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param requested
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requested(String requested);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param status
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Instant provisionTime;

        private String provisioned;

        private Instant requestTime;

        private String requested;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedBandwidth model) {
            provisionTime(model.provisionTime);
            provisioned(model.provisioned);
            requestTime(model.requestTime);
            requested(model.requested);
            status(model.status);
        }

        public final Instant getProvisionTime() {
            return provisionTime;
        }

        public final void setProvisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
        }

        @Override
        public final Builder provisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
            return this;
        }

        public final String getProvisioned() {
            return provisioned;
        }

        public final void setProvisioned(String provisioned) {
            this.provisioned = provisioned;
        }

        @Override
        public final Builder provisioned(String provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getRequested() {
            return requested;
        }

        public final void setRequested(String requested) {
            this.requested = requested;
        }

        @Override
        public final Builder requested(String requested) {
            this.requested = requested;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public ProvisionedBandwidth build() {
            return new ProvisionedBandwidth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
