/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the private DNS name for the service endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsNameConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsNameConfiguration.Builder, PrivateDnsNameConfiguration> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(PrivateDnsNameConfiguration::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(PrivateDnsNameConfiguration::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(PrivateDnsNameConfiguration::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("value").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(PrivateDnsNameConfiguration::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, TYPE_FIELD,
            VALUE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("State", STATE_FIELD);
                    put("Type", TYPE_FIELD);
                    put("Value", VALUE_FIELD);
                    put("Name", NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String type;

    private final String value;

    private final String name;

    private PrivateDnsNameConfiguration(BuilderImpl builder) {
        this.state = builder.state;
        this.type = builder.type;
        this.value = builder.value;
        this.name = builder.name;
    }

    /**
     * <p>
     * The verification state of the VPC endpoint service.
     * </p>
     * <p>
     * &gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DnsNameState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The verification state of the VPC endpoint service.</p>
     *         <p>
     *         &gt;Consumers of the endpoint service can use the private name only when the state is
     *         <code>verified</code>.
     * @see DnsNameState
     */
    public final DnsNameState state() {
        return DnsNameState.fromValue(state);
    }

    /**
     * <p>
     * The verification state of the VPC endpoint service.
     * </p>
     * <p>
     * &gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DnsNameState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The verification state of the VPC endpoint service.</p>
     *         <p>
     *         &gt;Consumers of the endpoint service can use the private name only when the state is
     *         <code>verified</code>.
     * @see DnsNameState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The endpoint service verification type, for example TXT.
     * </p>
     * 
     * @return The endpoint service verification type, for example TXT.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The value the service provider adds to the private DNS name domain record before verification.
     * </p>
     * 
     * @return The value the service provider adds to the private DNS name domain record before verification.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The name of the record subdomain the service provider needs to create. The service provider adds the
     * <code>value</code> text to the <code>name</code>.
     * </p>
     * 
     * @return The name of the record subdomain the service provider needs to create. The service provider adds the
     *         <code>value</code> text to the <code>name</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsNameConfiguration)) {
            return false;
        }
        PrivateDnsNameConfiguration other = (PrivateDnsNameConfiguration) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(type(), other.type())
                && Objects.equals(value(), other.value()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsNameConfiguration").add("State", stateAsString()).add("Type", type())
                .add("Value", value()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsNameConfiguration, T> g) {
        return obj -> g.apply((PrivateDnsNameConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsNameConfiguration> {
        /**
         * <p>
         * The verification state of the VPC endpoint service.
         * </p>
         * <p>
         * &gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.
         * </p>
         * 
         * @param state
         *        The verification state of the VPC endpoint service.</p>
         *        <p>
         *        &gt;Consumers of the endpoint service can use the private name only when the state is
         *        <code>verified</code>.
         * @see DnsNameState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsNameState
         */
        Builder state(String state);

        /**
         * <p>
         * The verification state of the VPC endpoint service.
         * </p>
         * <p>
         * &gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.
         * </p>
         * 
         * @param state
         *        The verification state of the VPC endpoint service.</p>
         *        <p>
         *        &gt;Consumers of the endpoint service can use the private name only when the state is
         *        <code>verified</code>.
         * @see DnsNameState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsNameState
         */
        Builder state(DnsNameState state);

        /**
         * <p>
         * The endpoint service verification type, for example TXT.
         * </p>
         * 
         * @param type
         *        The endpoint service verification type, for example TXT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The value the service provider adds to the private DNS name domain record before verification.
         * </p>
         * 
         * @param value
         *        The value the service provider adds to the private DNS name domain record before verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The name of the record subdomain the service provider needs to create. The service provider adds the
         * <code>value</code> text to the <code>name</code>.
         * </p>
         * 
         * @param name
         *        The name of the record subdomain the service provider needs to create. The service provider adds the
         *        <code>value</code> text to the <code>name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String type;

        private String value;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsNameConfiguration model) {
            state(model.state);
            type(model.type);
            value(model.value);
            name(model.name);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DnsNameState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public PrivateDnsNameConfiguration build() {
            return new PrivateDnsNameConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
