/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Classic Load Balancers and target groups to attach to a Spot Fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancersConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancersConfig.Builder, LoadBalancersConfig> {
    private static final SdkField<ClassicLoadBalancersConfig> CLASSIC_LOAD_BALANCERS_CONFIG_FIELD = SdkField
            .<ClassicLoadBalancersConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ClassicLoadBalancersConfig")
            .getter(getter(LoadBalancersConfig::classicLoadBalancersConfig))
            .setter(setter(Builder::classicLoadBalancersConfig))
            .constructor(ClassicLoadBalancersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancersConfig")
                    .unmarshallLocationName("classicLoadBalancersConfig").build()).build();

    private static final SdkField<TargetGroupsConfig> TARGET_GROUPS_CONFIG_FIELD = SdkField
            .<TargetGroupsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TargetGroupsConfig")
            .getter(getter(LoadBalancersConfig::targetGroupsConfig))
            .setter(setter(Builder::targetGroupsConfig))
            .constructor(TargetGroupsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupsConfig")
                    .unmarshallLocationName("targetGroupsConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLASSIC_LOAD_BALANCERS_CONFIG_FIELD, TARGET_GROUPS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClassicLoadBalancersConfig", CLASSIC_LOAD_BALANCERS_CONFIG_FIELD);
                    put("TargetGroupsConfig", TARGET_GROUPS_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ClassicLoadBalancersConfig classicLoadBalancersConfig;

    private final TargetGroupsConfig targetGroupsConfig;

    private LoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancersConfig = builder.classicLoadBalancersConfig;
        this.targetGroupsConfig = builder.targetGroupsConfig;
    }

    /**
     * <p>
     * The Classic Load Balancers.
     * </p>
     * 
     * @return The Classic Load Balancers.
     */
    public final ClassicLoadBalancersConfig classicLoadBalancersConfig() {
        return classicLoadBalancersConfig;
    }

    /**
     * <p>
     * The target groups.
     * </p>
     * 
     * @return The target groups.
     */
    public final TargetGroupsConfig targetGroupsConfig() {
        return targetGroupsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classicLoadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancersConfig)) {
            return false;
        }
        LoadBalancersConfig other = (LoadBalancersConfig) obj;
        return Objects.equals(classicLoadBalancersConfig(), other.classicLoadBalancersConfig())
                && Objects.equals(targetGroupsConfig(), other.targetGroupsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancersConfig").add("ClassicLoadBalancersConfig", classicLoadBalancersConfig())
                .add("TargetGroupsConfig", targetGroupsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLoadBalancersConfig":
            return Optional.ofNullable(clazz.cast(classicLoadBalancersConfig()));
        case "TargetGroupsConfig":
            return Optional.ofNullable(clazz.cast(targetGroupsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancersConfig, T> g) {
        return obj -> g.apply((LoadBalancersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancersConfig> {
        /**
         * <p>
         * The Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancersConfig
         *        The Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig classicLoadBalancersConfig);

        /**
         * <p>
         * The Classic Load Balancers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClassicLoadBalancersConfig.Builder}
         * avoiding the need to create one manually via {@link ClassicLoadBalancersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClassicLoadBalancersConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #classicLoadBalancersConfig(ClassicLoadBalancersConfig)}.
         * 
         * @param classicLoadBalancersConfig
         *        a consumer that will call methods on {@link ClassicLoadBalancersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classicLoadBalancersConfig(ClassicLoadBalancersConfig)
         */
        default Builder classicLoadBalancersConfig(Consumer<ClassicLoadBalancersConfig.Builder> classicLoadBalancersConfig) {
            return classicLoadBalancersConfig(ClassicLoadBalancersConfig.builder().applyMutation(classicLoadBalancersConfig)
                    .build());
        }

        /**
         * <p>
         * The target groups.
         * </p>
         * 
         * @param targetGroupsConfig
         *        The target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupsConfig(TargetGroupsConfig targetGroupsConfig);

        /**
         * <p>
         * The target groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetGroupsConfig.Builder} avoiding the
         * need to create one manually via {@link TargetGroupsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetGroupsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #targetGroupsConfig(TargetGroupsConfig)}.
         * 
         * @param targetGroupsConfig
         *        a consumer that will call methods on {@link TargetGroupsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroupsConfig(TargetGroupsConfig)
         */
        default Builder targetGroupsConfig(Consumer<TargetGroupsConfig.Builder> targetGroupsConfig) {
            return targetGroupsConfig(TargetGroupsConfig.builder().applyMutation(targetGroupsConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClassicLoadBalancersConfig classicLoadBalancersConfig;

        private TargetGroupsConfig targetGroupsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancersConfig model) {
            classicLoadBalancersConfig(model.classicLoadBalancersConfig);
            targetGroupsConfig(model.targetGroupsConfig);
        }

        public final ClassicLoadBalancersConfig.Builder getClassicLoadBalancersConfig() {
            return classicLoadBalancersConfig != null ? classicLoadBalancersConfig.toBuilder() : null;
        }

        public final void setClassicLoadBalancersConfig(ClassicLoadBalancersConfig.BuilderImpl classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig != null ? classicLoadBalancersConfig.build() : null;
        }

        @Override
        public final Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig;
            return this;
        }

        public final TargetGroupsConfig.Builder getTargetGroupsConfig() {
            return targetGroupsConfig != null ? targetGroupsConfig.toBuilder() : null;
        }

        public final void setTargetGroupsConfig(TargetGroupsConfig.BuilderImpl targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig != null ? targetGroupsConfig.build() : null;
        }

        @Override
        public final Builder targetGroupsConfig(TargetGroupsConfig targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig;
            return this;
        }

        @Override
        public LoadBalancersConfig build() {
            return new LoadBalancersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
