/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an
 * external resource. For example, you can use a verification token to validate that you control a public IP address
 * range when you bring an IP address range to Amazon Web Services (BYOIP).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamExternalResourceVerificationToken implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamExternalResourceVerificationToken.Builder, IpamExternalResourceVerificationToken> {
    private static final SdkField<String> IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamExternalResourceVerificationTokenId")
            .getter(getter(IpamExternalResourceVerificationToken::ipamExternalResourceVerificationTokenId))
            .setter(setter(Builder::ipamExternalResourceVerificationTokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IpamExternalResourceVerificationTokenId")
                    .unmarshallLocationName("ipamExternalResourceVerificationTokenId").build()).build();

    private static final SdkField<String> IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamExternalResourceVerificationTokenArn")
            .getter(getter(IpamExternalResourceVerificationToken::ipamExternalResourceVerificationTokenArn))
            .setter(setter(Builder::ipamExternalResourceVerificationTokenArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IpamExternalResourceVerificationTokenArn")
                    .unmarshallLocationName("ipamExternalResourceVerificationTokenArn").build()).build();

    private static final SdkField<String> IPAM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamId")
            .getter(getter(IpamExternalResourceVerificationToken::ipamId))
            .setter(setter(Builder::ipamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId")
                    .unmarshallLocationName("ipamId").build()).build();

    private static final SdkField<String> IPAM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamArn")
            .getter(getter(IpamExternalResourceVerificationToken::ipamArn))
            .setter(setter(Builder::ipamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn")
                    .unmarshallLocationName("ipamArn").build()).build();

    private static final SdkField<String> IPAM_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamRegion")
            .getter(getter(IpamExternalResourceVerificationToken::ipamRegion))
            .setter(setter(Builder::ipamRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion")
                    .unmarshallLocationName("ipamRegion").build()).build();

    private static final SdkField<String> TOKEN_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TokenValue")
            .getter(getter(IpamExternalResourceVerificationToken::tokenValue))
            .setter(setter(Builder::tokenValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValue")
                    .unmarshallLocationName("tokenValue").build()).build();

    private static final SdkField<String> TOKEN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TokenName")
            .getter(getter(IpamExternalResourceVerificationToken::tokenName))
            .setter(setter(Builder::tokenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenName")
                    .unmarshallLocationName("tokenName").build()).build();

    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotAfter")
            .getter(getter(IpamExternalResourceVerificationToken::notAfter))
            .setter(setter(Builder::notAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter")
                    .unmarshallLocationName("notAfter").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(IpamExternalResourceVerificationToken::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(IpamExternalResourceVerificationToken::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(IpamExternalResourceVerificationToken::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ID_FIELD, IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ARN_FIELD,
            IPAM_ID_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, TOKEN_VALUE_FIELD, TOKEN_NAME_FIELD, NOT_AFTER_FIELD, STATUS_FIELD,
            TAGS_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IpamExternalResourceVerificationTokenId", IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ID_FIELD);
                    put("IpamExternalResourceVerificationTokenArn", IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ARN_FIELD);
                    put("IpamId", IPAM_ID_FIELD);
                    put("IpamArn", IPAM_ARN_FIELD);
                    put("IpamRegion", IPAM_REGION_FIELD);
                    put("TokenValue", TOKEN_VALUE_FIELD);
                    put("TokenName", TOKEN_NAME_FIELD);
                    put("NotAfter", NOT_AFTER_FIELD);
                    put("Status", STATUS_FIELD);
                    put("TagSet", TAGS_FIELD);
                    put("State", STATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String ipamExternalResourceVerificationTokenId;

    private final String ipamExternalResourceVerificationTokenArn;

    private final String ipamId;

    private final String ipamArn;

    private final String ipamRegion;

    private final String tokenValue;

    private final String tokenName;

    private final Instant notAfter;

    private final String status;

    private final List<Tag> tags;

    private final String state;

    private IpamExternalResourceVerificationToken(BuilderImpl builder) {
        this.ipamExternalResourceVerificationTokenId = builder.ipamExternalResourceVerificationTokenId;
        this.ipamExternalResourceVerificationTokenArn = builder.ipamExternalResourceVerificationTokenArn;
        this.ipamId = builder.ipamId;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.tokenValue = builder.tokenValue;
        this.tokenName = builder.tokenName;
        this.notAfter = builder.notAfter;
        this.status = builder.status;
        this.tags = builder.tags;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the token.
     * </p>
     * 
     * @return The ID of the token.
     */
    public final String ipamExternalResourceVerificationTokenId() {
        return ipamExternalResourceVerificationTokenId;
    }

    /**
     * <p>
     * Token ARN.
     * </p>
     * 
     * @return Token ARN.
     */
    public final String ipamExternalResourceVerificationTokenArn() {
        return ipamExternalResourceVerificationTokenArn;
    }

    /**
     * <p>
     * The ID of the IPAM that created the token.
     * </p>
     * 
     * @return The ID of the IPAM that created the token.
     */
    public final String ipamId() {
        return ipamId;
    }

    /**
     * <p>
     * ARN of the IPAM that created the token.
     * </p>
     * 
     * @return ARN of the IPAM that created the token.
     */
    public final String ipamArn() {
        return ipamArn;
    }

    /**
     * <p>
     * Region of the IPAM that created the token.
     * </p>
     * 
     * @return Region of the IPAM that created the token.
     */
    public final String ipamRegion() {
        return ipamRegion;
    }

    /**
     * <p>
     * Token value.
     * </p>
     * 
     * @return Token value.
     */
    public final String tokenValue() {
        return tokenValue;
    }

    /**
     * <p>
     * Token name.
     * </p>
     * 
     * @return Token name.
     */
    public final String tokenName() {
        return tokenName;
    }

    /**
     * <p>
     * Token expiration.
     * </p>
     * 
     * @return Token expiration.
     */
    public final Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * Token status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TokenState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Token status.
     * @see TokenState
     */
    public final TokenState status() {
        return TokenState.fromValue(status);
    }

    /**
     * <p>
     * Token status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TokenState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Token status.
     * @see TokenState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Token tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Token tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Token state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamExternalResourceVerificationTokenState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return Token state.
     * @see IpamExternalResourceVerificationTokenState
     */
    public final IpamExternalResourceVerificationTokenState state() {
        return IpamExternalResourceVerificationTokenState.fromValue(state);
    }

    /**
     * <p>
     * Token state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamExternalResourceVerificationTokenState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return Token state.
     * @see IpamExternalResourceVerificationTokenState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipamExternalResourceVerificationTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(ipamExternalResourceVerificationTokenArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(tokenValue());
        hashCode = 31 * hashCode + Objects.hashCode(tokenName());
        hashCode = 31 * hashCode + Objects.hashCode(notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamExternalResourceVerificationToken)) {
            return false;
        }
        IpamExternalResourceVerificationToken other = (IpamExternalResourceVerificationToken) obj;
        return Objects.equals(ipamExternalResourceVerificationTokenId(), other.ipamExternalResourceVerificationTokenId())
                && Objects.equals(ipamExternalResourceVerificationTokenArn(), other.ipamExternalResourceVerificationTokenArn())
                && Objects.equals(ipamId(), other.ipamId()) && Objects.equals(ipamArn(), other.ipamArn())
                && Objects.equals(ipamRegion(), other.ipamRegion()) && Objects.equals(tokenValue(), other.tokenValue())
                && Objects.equals(tokenName(), other.tokenName()) && Objects.equals(notAfter(), other.notAfter())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamExternalResourceVerificationToken")
                .add("IpamExternalResourceVerificationTokenId", ipamExternalResourceVerificationTokenId())
                .add("IpamExternalResourceVerificationTokenArn", ipamExternalResourceVerificationTokenArn())
                .add("IpamId", ipamId()).add("IpamArn", ipamArn()).add("IpamRegion", ipamRegion())
                .add("TokenValue", tokenValue()).add("TokenName", tokenName()).add("NotAfter", notAfter())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamExternalResourceVerificationTokenId":
            return Optional.ofNullable(clazz.cast(ipamExternalResourceVerificationTokenId()));
        case "IpamExternalResourceVerificationTokenArn":
            return Optional.ofNullable(clazz.cast(ipamExternalResourceVerificationTokenArn()));
        case "IpamId":
            return Optional.ofNullable(clazz.cast(ipamId()));
        case "IpamArn":
            return Optional.ofNullable(clazz.cast(ipamArn()));
        case "IpamRegion":
            return Optional.ofNullable(clazz.cast(ipamRegion()));
        case "TokenValue":
            return Optional.ofNullable(clazz.cast(tokenValue()));
        case "TokenName":
            return Optional.ofNullable(clazz.cast(tokenName()));
        case "NotAfter":
            return Optional.ofNullable(clazz.cast(notAfter()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamExternalResourceVerificationToken, T> g) {
        return obj -> g.apply((IpamExternalResourceVerificationToken) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamExternalResourceVerificationToken> {
        /**
         * <p>
         * The ID of the token.
         * </p>
         * 
         * @param ipamExternalResourceVerificationTokenId
         *        The ID of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamExternalResourceVerificationTokenId(String ipamExternalResourceVerificationTokenId);

        /**
         * <p>
         * Token ARN.
         * </p>
         * 
         * @param ipamExternalResourceVerificationTokenArn
         *        Token ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamExternalResourceVerificationTokenArn(String ipamExternalResourceVerificationTokenArn);

        /**
         * <p>
         * The ID of the IPAM that created the token.
         * </p>
         * 
         * @param ipamId
         *        The ID of the IPAM that created the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamId(String ipamId);

        /**
         * <p>
         * ARN of the IPAM that created the token.
         * </p>
         * 
         * @param ipamArn
         *        ARN of the IPAM that created the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamArn(String ipamArn);

        /**
         * <p>
         * Region of the IPAM that created the token.
         * </p>
         * 
         * @param ipamRegion
         *        Region of the IPAM that created the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamRegion(String ipamRegion);

        /**
         * <p>
         * Token value.
         * </p>
         * 
         * @param tokenValue
         *        Token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenValue(String tokenValue);

        /**
         * <p>
         * Token name.
         * </p>
         * 
         * @param tokenName
         *        Token name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenName(String tokenName);

        /**
         * <p>
         * Token expiration.
         * </p>
         * 
         * @param notAfter
         *        Token expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * Token status.
         * </p>
         * 
         * @param status
         *        Token status.
         * @see TokenState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenState
         */
        Builder status(String status);

        /**
         * <p>
         * Token status.
         * </p>
         * 
         * @param status
         *        Token status.
         * @see TokenState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenState
         */
        Builder status(TokenState status);

        /**
         * <p>
         * Token tags.
         * </p>
         * 
         * @param tags
         *        Token tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Token tags.
         * </p>
         * 
         * @param tags
         *        Token tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Token tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Token state.
         * </p>
         * 
         * @param state
         *        Token state.
         * @see IpamExternalResourceVerificationTokenState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamExternalResourceVerificationTokenState
         */
        Builder state(String state);

        /**
         * <p>
         * Token state.
         * </p>
         * 
         * @param state
         *        Token state.
         * @see IpamExternalResourceVerificationTokenState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamExternalResourceVerificationTokenState
         */
        Builder state(IpamExternalResourceVerificationTokenState state);
    }

    static final class BuilderImpl implements Builder {
        private String ipamExternalResourceVerificationTokenId;

        private String ipamExternalResourceVerificationTokenArn;

        private String ipamId;

        private String ipamArn;

        private String ipamRegion;

        private String tokenValue;

        private String tokenName;

        private Instant notAfter;

        private String status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamExternalResourceVerificationToken model) {
            ipamExternalResourceVerificationTokenId(model.ipamExternalResourceVerificationTokenId);
            ipamExternalResourceVerificationTokenArn(model.ipamExternalResourceVerificationTokenArn);
            ipamId(model.ipamId);
            ipamArn(model.ipamArn);
            ipamRegion(model.ipamRegion);
            tokenValue(model.tokenValue);
            tokenName(model.tokenName);
            notAfter(model.notAfter);
            status(model.status);
            tags(model.tags);
            state(model.state);
        }

        public final String getIpamExternalResourceVerificationTokenId() {
            return ipamExternalResourceVerificationTokenId;
        }

        public final void setIpamExternalResourceVerificationTokenId(String ipamExternalResourceVerificationTokenId) {
            this.ipamExternalResourceVerificationTokenId = ipamExternalResourceVerificationTokenId;
        }

        @Override
        public final Builder ipamExternalResourceVerificationTokenId(String ipamExternalResourceVerificationTokenId) {
            this.ipamExternalResourceVerificationTokenId = ipamExternalResourceVerificationTokenId;
            return this;
        }

        public final String getIpamExternalResourceVerificationTokenArn() {
            return ipamExternalResourceVerificationTokenArn;
        }

        public final void setIpamExternalResourceVerificationTokenArn(String ipamExternalResourceVerificationTokenArn) {
            this.ipamExternalResourceVerificationTokenArn = ipamExternalResourceVerificationTokenArn;
        }

        @Override
        public final Builder ipamExternalResourceVerificationTokenArn(String ipamExternalResourceVerificationTokenArn) {
            this.ipamExternalResourceVerificationTokenArn = ipamExternalResourceVerificationTokenArn;
            return this;
        }

        public final String getIpamId() {
            return ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getIpamArn() {
            return ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getTokenValue() {
            return tokenValue;
        }

        public final void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @Override
        public final Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public final String getTokenName() {
            return tokenName;
        }

        public final void setTokenName(String tokenName) {
            this.tokenName = tokenName;
        }

        @Override
        public final Builder tokenName(String tokenName) {
            this.tokenName = tokenName;
            return this;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TokenState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamExternalResourceVerificationTokenState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public IpamExternalResourceVerificationToken build() {
            return new IpamExternalResourceVerificationToken(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
