/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVpnTunnelReplacementStatusResponse extends Ec2Response implements
        ToCopyableBuilder<GetVpnTunnelReplacementStatusResponse.Builder, GetVpnTunnelReplacementStatusResponse> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionId")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("vpnConnectionId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerGatewayId")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::customerGatewayId))
            .setter(setter(Builder::customerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId")
                    .unmarshallLocationName("customerGatewayId").build()).build();

    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnGatewayId")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::vpnGatewayId))
            .setter(setter(Builder::vpnGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId")
                    .unmarshallLocationName("vpnGatewayId").build()).build();

    private static final SdkField<String> VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnTunnelOutsideIpAddress")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::vpnTunnelOutsideIpAddress))
            .setter(setter(Builder::vpnTunnelOutsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOutsideIpAddress")
                    .unmarshallLocationName("vpnTunnelOutsideIpAddress").build()).build();

    private static final SdkField<MaintenanceDetails> MAINTENANCE_DETAILS_FIELD = SdkField
            .<MaintenanceDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceDetails")
            .getter(getter(GetVpnTunnelReplacementStatusResponse::maintenanceDetails))
            .setter(setter(Builder::maintenanceDetails))
            .constructor(MaintenanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceDetails")
                    .unmarshallLocationName("maintenanceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            TRANSIT_GATEWAY_ID_FIELD, CUSTOMER_GATEWAY_ID_FIELD, VPN_GATEWAY_ID_FIELD, VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD,
            MAINTENANCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
                    put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
                    put("CustomerGatewayId", CUSTOMER_GATEWAY_ID_FIELD);
                    put("VpnGatewayId", VPN_GATEWAY_ID_FIELD);
                    put("VpnTunnelOutsideIpAddress", VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD);
                    put("MaintenanceDetails", MAINTENANCE_DETAILS_FIELD);
                }
            });

    private final String vpnConnectionId;

    private final String transitGatewayId;

    private final String customerGatewayId;

    private final String vpnGatewayId;

    private final String vpnTunnelOutsideIpAddress;

    private final MaintenanceDetails maintenanceDetails;

    private GetVpnTunnelReplacementStatusResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
        this.customerGatewayId = builder.customerGatewayId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.vpnTunnelOutsideIpAddress = builder.vpnTunnelOutsideIpAddress;
        this.maintenanceDetails = builder.maintenanceDetails;
    }

    /**
     * <p>
     * The ID of the Site-to-Site VPN connection.
     * </p>
     * 
     * @return The ID of the Site-to-Site VPN connection.
     */
    public final String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The ID of the transit gateway associated with the VPN connection.
     * </p>
     * 
     * @return The ID of the transit gateway associated with the VPN connection.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public final String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public final String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The external IP address of the VPN tunnel.
     * </p>
     * 
     * @return The external IP address of the VPN tunnel.
     */
    public final String vpnTunnelOutsideIpAddress() {
        return vpnTunnelOutsideIpAddress;
    }

    /**
     * <p>
     * Get details of pending tunnel endpoint maintenance.
     * </p>
     * 
     * @return Get details of pending tunnel endpoint maintenance.
     */
    public final MaintenanceDetails maintenanceDetails() {
        return maintenanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnTunnelOutsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpnTunnelReplacementStatusResponse)) {
            return false;
        }
        GetVpnTunnelReplacementStatusResponse other = (GetVpnTunnelReplacementStatusResponse) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(customerGatewayId(), other.customerGatewayId())
                && Objects.equals(vpnGatewayId(), other.vpnGatewayId())
                && Objects.equals(vpnTunnelOutsideIpAddress(), other.vpnTunnelOutsideIpAddress())
                && Objects.equals(maintenanceDetails(), other.maintenanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVpnTunnelReplacementStatusResponse").add("VpnConnectionId", vpnConnectionId())
                .add("TransitGatewayId", transitGatewayId()).add("CustomerGatewayId", customerGatewayId())
                .add("VpnGatewayId", vpnGatewayId()).add("VpnTunnelOutsideIpAddress", vpnTunnelOutsideIpAddress())
                .add("MaintenanceDetails", maintenanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "CustomerGatewayId":
            return Optional.ofNullable(clazz.cast(customerGatewayId()));
        case "VpnGatewayId":
            return Optional.ofNullable(clazz.cast(vpnGatewayId()));
        case "VpnTunnelOutsideIpAddress":
            return Optional.ofNullable(clazz.cast(vpnTunnelOutsideIpAddress()));
        case "MaintenanceDetails":
            return Optional.ofNullable(clazz.cast(maintenanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVpnTunnelReplacementStatusResponse, T> g) {
        return obj -> g.apply((GetVpnTunnelReplacementStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVpnTunnelReplacementStatusResponse> {
        /**
         * <p>
         * The ID of the Site-to-Site VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the Site-to-Site VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The ID of the transit gateway associated with the VPN connection.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway associated with the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The external IP address of the VPN tunnel.
         * </p>
         * 
         * @param vpnTunnelOutsideIpAddress
         *        The external IP address of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress);

        /**
         * <p>
         * Get details of pending tunnel endpoint maintenance.
         * </p>
         * 
         * @param maintenanceDetails
         *        Get details of pending tunnel endpoint maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceDetails(MaintenanceDetails maintenanceDetails);

        /**
         * <p>
         * Get details of pending tunnel endpoint maintenance.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceDetails.Builder} avoiding the
         * need to create one manually via {@link MaintenanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceDetails(MaintenanceDetails)}.
         * 
         * @param maintenanceDetails
         *        a consumer that will call methods on {@link MaintenanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceDetails(MaintenanceDetails)
         */
        default Builder maintenanceDetails(Consumer<MaintenanceDetails.Builder> maintenanceDetails) {
            return maintenanceDetails(MaintenanceDetails.builder().applyMutation(maintenanceDetails).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String transitGatewayId;

        private String customerGatewayId;

        private String vpnGatewayId;

        private String vpnTunnelOutsideIpAddress;

        private MaintenanceDetails maintenanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpnTunnelReplacementStatusResponse model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            transitGatewayId(model.transitGatewayId);
            customerGatewayId(model.customerGatewayId);
            vpnGatewayId(model.vpnGatewayId);
            vpnTunnelOutsideIpAddress(model.vpnTunnelOutsideIpAddress);
            maintenanceDetails(model.maintenanceDetails);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final String getVpnTunnelOutsideIpAddress() {
            return vpnTunnelOutsideIpAddress;
        }

        public final void setVpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
        }

        @Override
        public final Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
            return this;
        }

        public final MaintenanceDetails.Builder getMaintenanceDetails() {
            return maintenanceDetails != null ? maintenanceDetails.toBuilder() : null;
        }

        public final void setMaintenanceDetails(MaintenanceDetails.BuilderImpl maintenanceDetails) {
            this.maintenanceDetails = maintenanceDetails != null ? maintenanceDetails.build() : null;
        }

        @Override
        public final Builder maintenanceDetails(MaintenanceDetails maintenanceDetails) {
            this.maintenanceDetails = maintenanceDetails;
            return this;
        }

        @Override
        public GetVpnTunnelReplacementStatusResponse build() {
            return new GetVpnTunnelReplacementStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
