/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceUefiDataResponse extends Ec2Response implements
        ToCopyableBuilder<GetInstanceUefiDataResponse.Builder, GetInstanceUefiDataResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(GetInstanceUefiDataResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> UEFI_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UefiData")
            .getter(getter(GetInstanceUefiDataResponse::uefiData))
            .setter(setter(Builder::uefiData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData")
                    .unmarshallLocationName("uefiData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            UEFI_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("UefiData", UEFI_DATA_FIELD);
                }
            });

    private final String instanceId;

    private final String uefiData;

    private GetInstanceUefiDataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.uefiData = builder.uefiData;
    }

    /**
     * <p>
     * The ID of the instance from which to retrieve the UEFI data.
     * </p>
     * 
     * @return The ID of the instance from which to retrieve the UEFI data.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Base64 representation of the non-volatile UEFI variable store.
     * </p>
     * 
     * @return Base64 representation of the non-volatile UEFI variable store.
     */
    public final String uefiData() {
        return uefiData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(uefiData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceUefiDataResponse)) {
            return false;
        }
        GetInstanceUefiDataResponse other = (GetInstanceUefiDataResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(uefiData(), other.uefiData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceUefiDataResponse").add("InstanceId", instanceId()).add("UefiData", uefiData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "UefiData":
            return Optional.ofNullable(clazz.cast(uefiData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceUefiDataResponse, T> g) {
        return obj -> g.apply((GetInstanceUefiDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceUefiDataResponse> {
        /**
         * <p>
         * The ID of the instance from which to retrieve the UEFI data.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance from which to retrieve the UEFI data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Base64 representation of the non-volatile UEFI variable store.
         * </p>
         * 
         * @param uefiData
         *        Base64 representation of the non-volatile UEFI variable store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uefiData(String uefiData);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String instanceId;

        private String uefiData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceUefiDataResponse model) {
            super(model);
            instanceId(model.instanceId);
            uefiData(model.uefiData);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getUefiData() {
            return uefiData;
        }

        public final void setUefiData(String uefiData) {
            this.uefiData = uefiData;
        }

        @Override
        public final Builder uefiData(String uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        @Override
        public GetInstanceUefiDataResponse build() {
            return new GetInstanceUefiDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
