/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableSnapshotBlockPublicAccessRequest extends Ec2Request implements
        ToCopyableBuilder<EnableSnapshotBlockPublicAccessRequest.Builder, EnableSnapshotBlockPublicAccessRequest> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(EnableSnapshotBlockPublicAccessRequest::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("State").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableSnapshotBlockPublicAccessRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("State", STATE_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String state;

    private final Boolean dryRun;

    private EnableSnapshotBlockPublicAccessRequest(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The mode in which to enable block public access for snapshots for the Region. Specify one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the account
     * will no longer be able to request new public sharing. Additionally, snapshots that are already publicly shared
     * are treated as private and they are no longer publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in the
     * account will no longer be able to request new public sharing. However, snapshots that are already publicly
     * shared, remain publicly available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The mode in which to enable block public access for snapshots for the Region. Specify one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the
     *         account will no longer be able to request new public sharing. Additionally, snapshots that are already
     *         publicly shared are treated as private and they are no longer publicly available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in
     *         the account will no longer be able to request new public sharing. However, snapshots that are already
     *         publicly shared, remain publicly available.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
     * @see SnapshotBlockPublicAccessState
     */
    public final SnapshotBlockPublicAccessState state() {
        return SnapshotBlockPublicAccessState.fromValue(state);
    }

    /**
     * <p>
     * The mode in which to enable block public access for snapshots for the Region. Specify one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the account
     * will no longer be able to request new public sharing. Additionally, snapshots that are already publicly shared
     * are treated as private and they are no longer publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in the
     * account will no longer be able to request new public sharing. However, snapshots that are already publicly
     * shared, remain publicly available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The mode in which to enable block public access for snapshots for the Region. Specify one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the
     *         account will no longer be able to request new public sharing. Additionally, snapshots that are already
     *         publicly shared are treated as private and they are no longer publicly available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in
     *         the account will no longer be able to request new public sharing. However, snapshots that are already
     *         publicly shared, remain publicly available.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
     * @see SnapshotBlockPublicAccessState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSnapshotBlockPublicAccessRequest)) {
            return false;
        }
        EnableSnapshotBlockPublicAccessRequest other = (EnableSnapshotBlockPublicAccessRequest) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableSnapshotBlockPublicAccessRequest").add("State", stateAsString()).add("DryRun", dryRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableSnapshotBlockPublicAccessRequest, T> g) {
        return obj -> g.apply((EnableSnapshotBlockPublicAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableSnapshotBlockPublicAccessRequest> {
        /**
         * <p>
         * The mode in which to enable block public access for snapshots for the Region. Specify one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the account
         * will no longer be able to request new public sharing. Additionally, snapshots that are already publicly
         * shared are treated as private and they are no longer publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in the
         * account will no longer be able to request new public sharing. However, snapshots that are already publicly
         * shared, remain publicly available.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
         * </p>
         * 
         * @param state
         *        The mode in which to enable block public access for snapshots for the Region. Specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the
         *        account will no longer be able to request new public sharing. Additionally, snapshots that are already
         *        publicly shared are treated as private and they are no longer publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in
         *        the account will no longer be able to request new public sharing. However, snapshots that are already
         *        publicly shared, remain publicly available.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
         * @see SnapshotBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotBlockPublicAccessState
         */
        Builder state(String state);

        /**
         * <p>
         * The mode in which to enable block public access for snapshots for the Region. Specify one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the account
         * will no longer be able to request new public sharing. Additionally, snapshots that are already publicly
         * shared are treated as private and they are no longer publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in the
         * account will no longer be able to request new public sharing. However, snapshots that are already publicly
         * shared, remain publicly available.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
         * </p>
         * 
         * @param state
         *        The mode in which to enable block public access for snapshots for the Region. Specify one of the
         *        following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>block-all-sharing</code> - Prevents all public sharing of snapshots in the Region. Users in the
         *        account will no longer be able to request new public sharing. Additionally, snapshots that are already
         *        publicly shared are treated as private and they are no longer publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-new-sharing</code> - Prevents only new public sharing of snapshots in the Region. Users in
         *        the account will no longer be able to request new public sharing. However, snapshots that are already
         *        publicly shared, remain publicly available.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>unblocked</code> is not a valid value for <b>EnableSnapshotBlockPublicAccess</b>.
         * @see SnapshotBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotBlockPublicAccessState
         */
        Builder state(SnapshotBlockPublicAccessState state);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String state;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSnapshotBlockPublicAccessRequest model) {
            super(model);
            state(model.state);
            dryRun(model.dryRun);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotBlockPublicAccessState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSnapshotBlockPublicAccessRequest build() {
            return new EnableSnapshotBlockPublicAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
