/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastLaunchRequest extends Ec2Request implements
        ToCopyableBuilder<EnableFastLaunchRequest.Builder, EnableFastLaunchRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(EnableFastLaunchRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(EnableFastLaunchRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("ResourceType").build()).build();

    private static final SdkField<FastLaunchSnapshotConfigurationRequest> SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<FastLaunchSnapshotConfigurationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SnapshotConfiguration")
            .getter(getter(EnableFastLaunchRequest::snapshotConfiguration))
            .setter(setter(Builder::snapshotConfiguration))
            .constructor(FastLaunchSnapshotConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration")
                    .unmarshallLocationName("SnapshotConfiguration").build()).build();

    private static final SdkField<FastLaunchLaunchTemplateSpecificationRequest> LAUNCH_TEMPLATE_FIELD = SdkField
            .<FastLaunchLaunchTemplateSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate")
            .getter(getter(EnableFastLaunchRequest::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(FastLaunchLaunchTemplateSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate")
                    .unmarshallLocationName("LaunchTemplate").build()).build();

    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxParallelLaunches")
            .getter(getter(EnableFastLaunchRequest::maxParallelLaunches))
            .setter(setter(Builder::maxParallelLaunches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelLaunches")
                    .unmarshallLocationName("MaxParallelLaunches").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableFastLaunchRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, RESOURCE_TYPE_FIELD, SNAPSHOT_CONFIGURATION_FIELD,
                    LAUNCH_TEMPLATE_FIELD, MAX_PARALLEL_LAUNCHES_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ImageId", IMAGE_ID_FIELD);
                    put("ResourceType", RESOURCE_TYPE_FIELD);
                    put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
                    put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
                    put("MaxParallelLaunches", MAX_PARALLEL_LAUNCHES_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String imageId;

    private final String resourceType;

    private final FastLaunchSnapshotConfigurationRequest snapshotConfiguration;

    private final FastLaunchLaunchTemplateSpecificationRequest launchTemplate;

    private final Integer maxParallelLaunches;

    private final Boolean dryRun;

    private EnableFastLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.resourceType = builder.resourceType;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.launchTemplate = builder.launchTemplate;
        this.maxParallelLaunches = builder.maxParallelLaunches;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * Specify the ID of the image for which to enable Windows fast launch.
     * </p>
     * 
     * @return Specify the ID of the image for which to enable Windows fast launch.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The type of resource to use for pre-provisioning the AMI for Windows fast launch. Supported values include:
     * <code>snapshot</code>, which is the default value.
     * </p>
     * 
     * @return The type of resource to use for pre-provisioning the AMI for Windows fast launch. Supported values
     *         include: <code>snapshot</code>, which is the default value.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Configuration settings for creating and managing the snapshots that are used for pre-provisioning the AMI for
     * Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.
     * </p>
     * 
     * @return Configuration settings for creating and managing the snapshots that are used for pre-provisioning the AMI
     *         for Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.
     */
    public final FastLaunchSnapshotConfigurationRequest snapshotConfiguration() {
        return snapshotConfiguration;
    }

    /**
     * <p>
     * The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch template
     * parameters can include either the name or ID of the launch template, but not both.
     * </p>
     * 
     * @return The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch
     *         template parameters can include either the name or ID of the launch template, but not both.
     */
    public final FastLaunchLaunchTemplateSpecificationRequest launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The maximum number of instances that Amazon EC2 can launch at the same time to create pre-provisioned snapshots
     * for Windows fast launch. Value must be <code>6</code> or greater.
     * </p>
     * 
     * @return The maximum number of instances that Amazon EC2 can launch at the same time to create pre-provisioned
     *         snapshots for Windows fast launch. Value must be <code>6</code> or greater.
     */
    public final Integer maxParallelLaunches() {
        return maxParallelLaunches;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelLaunches());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastLaunchRequest)) {
            return false;
        }
        EnableFastLaunchRequest other = (EnableFastLaunchRequest) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(snapshotConfiguration(), other.snapshotConfiguration())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(maxParallelLaunches(), other.maxParallelLaunches()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFastLaunchRequest").add("ImageId", imageId()).add("ResourceType", resourceType())
                .add("SnapshotConfiguration", snapshotConfiguration()).add("LaunchTemplate", launchTemplate())
                .add("MaxParallelLaunches", maxParallelLaunches()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "SnapshotConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotConfiguration()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MaxParallelLaunches":
            return Optional.ofNullable(clazz.cast(maxParallelLaunches()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastLaunchRequest, T> g) {
        return obj -> g.apply((EnableFastLaunchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableFastLaunchRequest> {
        /**
         * <p>
         * Specify the ID of the image for which to enable Windows fast launch.
         * </p>
         * 
         * @param imageId
         *        Specify the ID of the image for which to enable Windows fast launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The type of resource to use for pre-provisioning the AMI for Windows fast launch. Supported values include:
         * <code>snapshot</code>, which is the default value.
         * </p>
         * 
         * @param resourceType
         *        The type of resource to use for pre-provisioning the AMI for Windows fast launch. Supported values
         *        include: <code>snapshot</code>, which is the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Configuration settings for creating and managing the snapshots that are used for pre-provisioning the AMI for
         * Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.
         * </p>
         * 
         * @param snapshotConfiguration
         *        Configuration settings for creating and managing the snapshots that are used for pre-provisioning the
         *        AMI for Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotConfiguration(FastLaunchSnapshotConfigurationRequest snapshotConfiguration);

        /**
         * <p>
         * Configuration settings for creating and managing the snapshots that are used for pre-provisioning the AMI for
         * Windows fast launch. The associated <code>ResourceType</code> must be <code>snapshot</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FastLaunchSnapshotConfigurationRequest.Builder} avoiding the need to create one manually via
         * {@link FastLaunchSnapshotConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchSnapshotConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #snapshotConfiguration(FastLaunchSnapshotConfigurationRequest)}.
         * 
         * @param snapshotConfiguration
         *        a consumer that will call methods on {@link FastLaunchSnapshotConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotConfiguration(FastLaunchSnapshotConfigurationRequest)
         */
        default Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfigurationRequest.Builder> snapshotConfiguration) {
            return snapshotConfiguration(FastLaunchSnapshotConfigurationRequest.builder().applyMutation(snapshotConfiguration)
                    .build());
        }

        /**
         * <p>
         * The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch template
         * parameters can include either the name or ID of the launch template, but not both.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch
         *        template parameters can include either the name or ID of the launch template, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(FastLaunchLaunchTemplateSpecificationRequest launchTemplate);

        /**
         * <p>
         * The launch template to use when launching Windows instances from pre-provisioned snapshots. Launch template
         * parameters can include either the name or ID of the launch template, but not both.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FastLaunchLaunchTemplateSpecificationRequest.Builder} avoiding the need to create one manually via
         * {@link FastLaunchLaunchTemplateSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchLaunchTemplateSpecificationRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #launchTemplate(FastLaunchLaunchTemplateSpecificationRequest)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link FastLaunchLaunchTemplateSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(FastLaunchLaunchTemplateSpecificationRequest)
         */
        default Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecificationRequest.Builder> launchTemplate) {
            return launchTemplate(FastLaunchLaunchTemplateSpecificationRequest.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The maximum number of instances that Amazon EC2 can launch at the same time to create pre-provisioned
         * snapshots for Windows fast launch. Value must be <code>6</code> or greater.
         * </p>
         * 
         * @param maxParallelLaunches
         *        The maximum number of instances that Amazon EC2 can launch at the same time to create pre-provisioned
         *        snapshots for Windows fast launch. Value must be <code>6</code> or greater.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelLaunches(Integer maxParallelLaunches);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String imageId;

        private String resourceType;

        private FastLaunchSnapshotConfigurationRequest snapshotConfiguration;

        private FastLaunchLaunchTemplateSpecificationRequest launchTemplate;

        private Integer maxParallelLaunches;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastLaunchRequest model) {
            super(model);
            imageId(model.imageId);
            resourceType(model.resourceType);
            snapshotConfiguration(model.snapshotConfiguration);
            launchTemplate(model.launchTemplate);
            maxParallelLaunches(model.maxParallelLaunches);
            dryRun(model.dryRun);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final FastLaunchSnapshotConfigurationRequest.Builder getSnapshotConfiguration() {
            return snapshotConfiguration != null ? snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfigurationRequest.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfigurationRequest snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecificationRequest.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecificationRequest.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecificationRequest launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFastLaunchRequest build() {
            return new EnableFastLaunchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
