/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStoreImageTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeStoreImageTasksResponse.Builder, DescribeStoreImageTasksResponse> {
    private static final SdkField<List<StoreImageTaskResult>> STORE_IMAGE_TASK_RESULTS_FIELD = SdkField
            .<List<StoreImageTaskResult>> builder(MarshallingType.LIST)
            .memberName("StoreImageTaskResults")
            .getter(getter(DescribeStoreImageTasksResponse::storeImageTaskResults))
            .setter(setter(Builder::storeImageTaskResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreImageTaskResultSet")
                    .unmarshallLocationName("storeImageTaskResultSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<StoreImageTaskResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(StoreImageTaskResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeStoreImageTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORE_IMAGE_TASK_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StoreImageTaskResultSet", STORE_IMAGE_TASK_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<StoreImageTaskResult> storeImageTaskResults;

    private final String nextToken;

    private DescribeStoreImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.storeImageTaskResults = builder.storeImageTaskResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StoreImageTaskResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStoreImageTaskResults() {
        return storeImageTaskResults != null && !(storeImageTaskResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about the AMI store tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStoreImageTaskResults} method.
     * </p>
     * 
     * @return The information about the AMI store tasks.
     */
    public final List<StoreImageTaskResult> storeImageTaskResults() {
        return storeImageTaskResults;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStoreImageTaskResults() ? storeImageTaskResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStoreImageTasksResponse)) {
            return false;
        }
        DescribeStoreImageTasksResponse other = (DescribeStoreImageTasksResponse) obj;
        return hasStoreImageTaskResults() == other.hasStoreImageTaskResults()
                && Objects.equals(storeImageTaskResults(), other.storeImageTaskResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStoreImageTasksResponse")
                .add("StoreImageTaskResults", hasStoreImageTaskResults() ? storeImageTaskResults() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoreImageTaskResults":
            return Optional.ofNullable(clazz.cast(storeImageTaskResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStoreImageTasksResponse, T> g) {
        return obj -> g.apply((DescribeStoreImageTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStoreImageTasksResponse> {
        /**
         * <p>
         * The information about the AMI store tasks.
         * </p>
         * 
         * @param storeImageTaskResults
         *        The information about the AMI store tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeImageTaskResults(Collection<StoreImageTaskResult> storeImageTaskResults);

        /**
         * <p>
         * The information about the AMI store tasks.
         * </p>
         * 
         * @param storeImageTaskResults
         *        The information about the AMI store tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeImageTaskResults(StoreImageTaskResult... storeImageTaskResults);

        /**
         * <p>
         * The information about the AMI store tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.StoreImageTaskResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.StoreImageTaskResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.StoreImageTaskResult.Builder#build()} is called immediately
         * and its result is passed to {@link #storeImageTaskResults(List<StoreImageTaskResult>)}.
         * 
         * @param storeImageTaskResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.StoreImageTaskResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storeImageTaskResults(java.util.Collection<StoreImageTaskResult>)
         */
        Builder storeImageTaskResults(Consumer<StoreImageTaskResult.Builder>... storeImageTaskResults);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<StoreImageTaskResult> storeImageTaskResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStoreImageTasksResponse model) {
            super(model);
            storeImageTaskResults(model.storeImageTaskResults);
            nextToken(model.nextToken);
        }

        public final List<StoreImageTaskResult.Builder> getStoreImageTaskResults() {
            List<StoreImageTaskResult.Builder> result = StoreImageTaskResultSetCopier.copyToBuilder(this.storeImageTaskResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoreImageTaskResults(Collection<StoreImageTaskResult.BuilderImpl> storeImageTaskResults) {
            this.storeImageTaskResults = StoreImageTaskResultSetCopier.copyFromBuilder(storeImageTaskResults);
        }

        @Override
        public final Builder storeImageTaskResults(Collection<StoreImageTaskResult> storeImageTaskResults) {
            this.storeImageTaskResults = StoreImageTaskResultSetCopier.copy(storeImageTaskResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storeImageTaskResults(StoreImageTaskResult... storeImageTaskResults) {
            storeImageTaskResults(Arrays.asList(storeImageTaskResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storeImageTaskResults(Consumer<StoreImageTaskResult.Builder>... storeImageTaskResults) {
            storeImageTaskResults(Stream.of(storeImageTaskResults)
                    .map(c -> StoreImageTaskResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStoreImageTasksResponse build() {
            return new DescribeStoreImageTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
