/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStaleSecurityGroupsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeStaleSecurityGroupsResponse.Builder, DescribeStaleSecurityGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeStaleSecurityGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<StaleSecurityGroup>> STALE_SECURITY_GROUP_SET_FIELD = SdkField
            .<List<StaleSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("StaleSecurityGroupSet")
            .getter(getter(DescribeStaleSecurityGroupsResponse::staleSecurityGroupSet))
            .setter(setter(Builder::staleSecurityGroupSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleSecurityGroupSet")
                    .unmarshallLocationName("staleSecurityGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<StaleSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(StaleSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STALE_SECURITY_GROUP_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("StaleSecurityGroupSet", STALE_SECURITY_GROUP_SET_FIELD);
                }
            });

    private final String nextToken;

    private final List<StaleSecurityGroup> staleSecurityGroupSet;

    private DescribeStaleSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.staleSecurityGroupSet = builder.staleSecurityGroupSet;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaleSecurityGroupSet property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStaleSecurityGroupSet() {
        return staleSecurityGroupSet != null && !(staleSecurityGroupSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stale security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaleSecurityGroupSet} method.
     * </p>
     * 
     * @return Information about the stale security groups.
     */
    public final List<StaleSecurityGroup> staleSecurityGroupSet() {
        return staleSecurityGroupSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaleSecurityGroupSet() ? staleSecurityGroupSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStaleSecurityGroupsResponse)) {
            return false;
        }
        DescribeStaleSecurityGroupsResponse other = (DescribeStaleSecurityGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStaleSecurityGroupSet() == other.hasStaleSecurityGroupSet()
                && Objects.equals(staleSecurityGroupSet(), other.staleSecurityGroupSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStaleSecurityGroupsResponse").add("NextToken", nextToken())
                .add("StaleSecurityGroupSet", hasStaleSecurityGroupSet() ? staleSecurityGroupSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StaleSecurityGroupSet":
            return Optional.ofNullable(clazz.cast(staleSecurityGroupSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStaleSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeStaleSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.StaleSecurityGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.StaleSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.StaleSecurityGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #staleSecurityGroupSet(List<StaleSecurityGroup>)}.
         * 
         * @param staleSecurityGroupSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.StaleSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staleSecurityGroupSet(java.util.Collection<StaleSecurityGroup>)
         */
        Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder>... staleSecurityGroupSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<StaleSecurityGroup> staleSecurityGroupSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStaleSecurityGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            staleSecurityGroupSet(model.staleSecurityGroupSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StaleSecurityGroup.Builder> getStaleSecurityGroupSet() {
            List<StaleSecurityGroup.Builder> result = StaleSecurityGroupSetCopier.copyToBuilder(this.staleSecurityGroupSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaleSecurityGroupSet(Collection<StaleSecurityGroup.BuilderImpl> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copyFromBuilder(staleSecurityGroupSet);
        }

        @Override
        public final Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet) {
            staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder>... staleSecurityGroupSet) {
            staleSecurityGroupSet(Stream.of(staleSecurityGroupSet)
                    .map(c -> StaleSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeStaleSecurityGroupsResponse build() {
            return new DescribeStaleSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
