/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotTierStatusResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSnapshotTierStatusResponse.Builder, DescribeSnapshotTierStatusResponse> {
    private static final SdkField<List<SnapshotTierStatus>> SNAPSHOT_TIER_STATUSES_FIELD = SdkField
            .<List<SnapshotTierStatus>> builder(MarshallingType.LIST)
            .memberName("SnapshotTierStatuses")
            .getter(getter(DescribeSnapshotTierStatusResponse::snapshotTierStatuses))
            .setter(setter(Builder::snapshotTierStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTierStatusSet")
                    .unmarshallLocationName("snapshotTierStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SnapshotTierStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotTierStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSnapshotTierStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_TIER_STATUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SnapshotTierStatusSet", SNAPSHOT_TIER_STATUSES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<SnapshotTierStatus> snapshotTierStatuses;

    private final String nextToken;

    private DescribeSnapshotTierStatusResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotTierStatuses = builder.snapshotTierStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotTierStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotTierStatuses() {
        return snapshotTierStatuses != null && !(snapshotTierStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshot's storage tier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotTierStatuses} method.
     * </p>
     * 
     * @return Information about the snapshot's storage tier.
     */
    public final List<SnapshotTierStatus> snapshotTierStatuses() {
        return snapshotTierStatuses;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotTierStatuses() ? snapshotTierStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotTierStatusResponse)) {
            return false;
        }
        DescribeSnapshotTierStatusResponse other = (DescribeSnapshotTierStatusResponse) obj;
        return hasSnapshotTierStatuses() == other.hasSnapshotTierStatuses()
                && Objects.equals(snapshotTierStatuses(), other.snapshotTierStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotTierStatusResponse")
                .add("SnapshotTierStatuses", hasSnapshotTierStatuses() ? snapshotTierStatuses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotTierStatuses":
            return Optional.ofNullable(clazz.cast(snapshotTierStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotTierStatusResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotTierStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotTierStatusResponse> {
        /**
         * <p>
         * Information about the snapshot's storage tier.
         * </p>
         * 
         * @param snapshotTierStatuses
         *        Information about the snapshot's storage tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTierStatuses(Collection<SnapshotTierStatus> snapshotTierStatuses);

        /**
         * <p>
         * Information about the snapshot's storage tier.
         * </p>
         * 
         * @param snapshotTierStatuses
         *        Information about the snapshot's storage tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTierStatuses(SnapshotTierStatus... snapshotTierStatuses);

        /**
         * <p>
         * Information about the snapshot's storage tier.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SnapshotTierStatus.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SnapshotTierStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SnapshotTierStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #snapshotTierStatuses(List<SnapshotTierStatus>)}.
         * 
         * @param snapshotTierStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SnapshotTierStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotTierStatuses(java.util.Collection<SnapshotTierStatus>)
         */
        Builder snapshotTierStatuses(Consumer<SnapshotTierStatus.Builder>... snapshotTierStatuses);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SnapshotTierStatus> snapshotTierStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotTierStatusResponse model) {
            super(model);
            snapshotTierStatuses(model.snapshotTierStatuses);
            nextToken(model.nextToken);
        }

        public final List<SnapshotTierStatus.Builder> getSnapshotTierStatuses() {
            List<SnapshotTierStatus.Builder> result = _snapshotTierStatusSetCopier.copyToBuilder(this.snapshotTierStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotTierStatuses(Collection<SnapshotTierStatus.BuilderImpl> snapshotTierStatuses) {
            this.snapshotTierStatuses = _snapshotTierStatusSetCopier.copyFromBuilder(snapshotTierStatuses);
        }

        @Override
        public final Builder snapshotTierStatuses(Collection<SnapshotTierStatus> snapshotTierStatuses) {
            this.snapshotTierStatuses = _snapshotTierStatusSetCopier.copy(snapshotTierStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotTierStatuses(SnapshotTierStatus... snapshotTierStatuses) {
            snapshotTierStatuses(Arrays.asList(snapshotTierStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotTierStatuses(Consumer<SnapshotTierStatus.Builder>... snapshotTierStatuses) {
            snapshotTierStatuses(Stream.of(snapshotTierStatuses).map(c -> SnapshotTierStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSnapshotTierStatusResponse build() {
            return new DescribeSnapshotTierStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
