/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityReservationsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeCapacityReservationsRequest.Builder, DescribeCapacityReservationsRequest> {
    private static final SdkField<List<String>> CAPACITY_RESERVATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CapacityReservationIds")
            .getter(getter(DescribeCapacityReservationsRequest::capacityReservationIds))
            .setter(setter(Builder::capacityReservationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("CapacityReservationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityReservationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeCapacityReservationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeCapacityReservationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeCapacityReservationsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CapacityReservationId", CAPACITY_RESERVATION_IDS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("Filter", FILTERS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final List<String> capacityReservationIds;

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private final Boolean dryRun;

    private DescribeCapacityReservationsRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationIds = builder.capacityReservationIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityReservationIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityReservationIds() {
        return capacityReservationIds != null && !(capacityReservationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityReservationIds} method.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final List<String> capacityReservationIds() {
        return capacityReservationIds;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves
     * capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of
     * the following tenancy settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
     * Services accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was
     * created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the
     * following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for
     * your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request
     * parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>start-date</code> - The date and time at which the Capacity Reservation was started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation
     * expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity
     * Reservation's state changes to expired when it reaches its end date and time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can
     * have one of the following end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation
     * accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type,
     * platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation was
     * created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves
     *         capacity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have
     *         one of the following tenancy settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon
     *         Web Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single Amazon Web Services account.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity
     *         Reservation was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one
     *         of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer
     *         available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
     *         request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for
     *         60 minutes.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-date</code> - The date and time at which the Capacity Reservation was started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
     *         Reservation expires, the reserved capacity is released and you can no longer launch instances into it.
     *         The Capacity Reservation's state changes to expired when it reaches its end date and time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity
     *         Reservation can have one of the following end types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity
     *         Reservation accepts. The options include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
     *         (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the
     *         Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity
     *         Reservation was created.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityReservationIds() ? capacityReservationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationsRequest)) {
            return false;
        }
        DescribeCapacityReservationsRequest other = (DescribeCapacityReservationsRequest) obj;
        return hasCapacityReservationIds() == other.hasCapacityReservationIds()
                && Objects.equals(capacityReservationIds(), other.capacityReservationIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityReservationsRequest")
                .add("CapacityReservationIds", hasCapacityReservationIds() ? capacityReservationIds() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationIds":
            return Optional.ofNullable(clazz.cast(capacityReservationIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationsRequest, T> g) {
        return obj -> g.apply((DescribeCapacityReservationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCapacityReservationsRequest> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationIds
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationIds(Collection<String> capacityReservationIds);

        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationIds
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationIds(String... capacityReservationIds);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves
         * capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one
         * of the following tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of
         * the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available
         * for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>start-date</code> - The date and time at which the Capacity Reservation was started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
         * Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The
         * Capacity Reservation's state changes to expired when it reaches its end date and time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation
         * can have one of the following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation
         * accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves
         *        capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-platform</code> - The type of operating system for which the Capacity Reservation
         *        reserves capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can
         *        have one of the following tenancy settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity
         *        Reservation was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in
         *        one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer
         *        available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-date</code> - The date and time at which the Capacity Reservation was started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
         *        Reservation expires, the reserved capacity is released and you can no longer launch instances into it.
         *        The Capacity Reservation's state changes to expired when it reaches its end date and time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity
         *        Reservation can have one of the following end types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity
         *        Reservation accepts. The options include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity
         *        Reservation was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves
         * capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one
         * of the following tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of
         * the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available
         * for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>start-date</code> - The date and time at which the Capacity Reservation was started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
         * Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The
         * Capacity Reservation's state changes to expired when it reaches its end date and time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation
         * can have one of the following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation
         * accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves
         *        capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-platform</code> - The type of operating system for which the Capacity Reservation
         *        reserves capacity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can
         *        have one of the following tenancy settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity
         *        Reservation was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in
         *        one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer
         *        available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-date</code> - The date and time at which the Capacity Reservation was started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
         *        Reservation expires, the reserved capacity is released and you can no longer launch instances into it.
         *        The Capacity Reservation's state changes to expired when it reaches its end date and time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity
         *        Reservation can have one of the following end types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity
         *        Reservation accepts. The options include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity
         *        Reservation was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves
         * capacity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one
         * of the following tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of
         * the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available
         * for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>start-date</code> - The date and time at which the Capacity Reservation was started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity
         * Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The
         * Capacity Reservation's state changes to expired when it reaches its end date and time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation
         * can have one of the following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation
         * accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation
         * was created.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> capacityReservationIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationsRequest model) {
            super(model);
            capacityReservationIds(model.capacityReservationIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            dryRun(model.dryRun);
        }

        public final Collection<String> getCapacityReservationIds() {
            if (capacityReservationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityReservationIds;
        }

        public final void setCapacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdSetCopier.copy(capacityReservationIds);
        }

        @Override
        public final Builder capacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdSetCopier.copy(capacityReservationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationIds(String... capacityReservationIds) {
            capacityReservationIds(Arrays.asList(capacityReservationIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityReservationsRequest build() {
            return new DescribeCapacityReservationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
