/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddressTransfersResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeAddressTransfersResponse.Builder, DescribeAddressTransfersResponse> {
    private static final SdkField<List<AddressTransfer>> ADDRESS_TRANSFERS_FIELD = SdkField
            .<List<AddressTransfer>> builder(MarshallingType.LIST)
            .memberName("AddressTransfers")
            .getter(getter(DescribeAddressTransfersResponse::addressTransfers))
            .setter(setter(Builder::addressTransfers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressTransferSet")
                    .unmarshallLocationName("addressTransferSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AddressTransfer> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddressTransfer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeAddressTransfersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_TRANSFERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AddressTransferSet", ADDRESS_TRANSFERS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<AddressTransfer> addressTransfers;

    private final String nextToken;

    private DescribeAddressTransfersResponse(BuilderImpl builder) {
        super(builder);
        this.addressTransfers = builder.addressTransfers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressTransfers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressTransfers() {
        return addressTransfers != null && !(addressTransfers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic IP address transfer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressTransfers} method.
     * </p>
     * 
     * @return The Elastic IP address transfer.
     */
    public final List<AddressTransfer> addressTransfers() {
        return addressTransfers;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressTransfers() ? addressTransfers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressTransfersResponse)) {
            return false;
        }
        DescribeAddressTransfersResponse other = (DescribeAddressTransfersResponse) obj;
        return hasAddressTransfers() == other.hasAddressTransfers()
                && Objects.equals(addressTransfers(), other.addressTransfers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAddressTransfersResponse")
                .add("AddressTransfers", hasAddressTransfers() ? addressTransfers() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressTransfers":
            return Optional.ofNullable(clazz.cast(addressTransfers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressTransfersResponse, T> g) {
        return obj -> g.apply((DescribeAddressTransfersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddressTransfersResponse> {
        /**
         * <p>
         * The Elastic IP address transfer.
         * </p>
         * 
         * @param addressTransfers
         *        The Elastic IP address transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressTransfers(Collection<AddressTransfer> addressTransfers);

        /**
         * <p>
         * The Elastic IP address transfer.
         * </p>
         * 
         * @param addressTransfers
         *        The Elastic IP address transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressTransfers(AddressTransfer... addressTransfers);

        /**
         * <p>
         * The Elastic IP address transfer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddressTransfer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AddressTransfer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddressTransfer.Builder#build()} is called immediately and
         * its result is passed to {@link #addressTransfers(List<AddressTransfer>)}.
         * 
         * @param addressTransfers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddressTransfer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressTransfers(java.util.Collection<AddressTransfer>)
         */
        Builder addressTransfers(Consumer<AddressTransfer.Builder>... addressTransfers);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<AddressTransfer> addressTransfers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressTransfersResponse model) {
            super(model);
            addressTransfers(model.addressTransfers);
            nextToken(model.nextToken);
        }

        public final List<AddressTransfer.Builder> getAddressTransfers() {
            List<AddressTransfer.Builder> result = AddressTransferListCopier.copyToBuilder(this.addressTransfers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressTransfers(Collection<AddressTransfer.BuilderImpl> addressTransfers) {
            this.addressTransfers = AddressTransferListCopier.copyFromBuilder(addressTransfers);
        }

        @Override
        public final Builder addressTransfers(Collection<AddressTransfer> addressTransfers) {
            this.addressTransfers = AddressTransferListCopier.copy(addressTransfers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressTransfers(AddressTransfer... addressTransfers) {
            addressTransfers(Arrays.asList(addressTransfers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressTransfers(Consumer<AddressTransfer.Builder>... addressTransfers) {
            addressTransfers(Stream.of(addressTransfers).map(c -> AddressTransfer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAddressTransfersResponse build() {
            return new DescribeAddressTransfersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
