/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprovisionIpamPoolCidrResponse extends Ec2Response implements
        ToCopyableBuilder<DeprovisionIpamPoolCidrResponse.Builder, DeprovisionIpamPoolCidrResponse> {
    private static final SdkField<IpamPoolCidr> IPAM_POOL_CIDR_FIELD = SdkField
            .<IpamPoolCidr> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPoolCidr")
            .getter(getter(DeprovisionIpamPoolCidrResponse::ipamPoolCidr))
            .setter(setter(Builder::ipamPoolCidr))
            .constructor(IpamPoolCidr::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolCidr")
                    .unmarshallLocationName("ipamPoolCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_CIDR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IpamPoolCidr", IPAM_POOL_CIDR_FIELD);
                }
            });

    private final IpamPoolCidr ipamPoolCidr;

    private DeprovisionIpamPoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPoolCidr = builder.ipamPoolCidr;
    }

    /**
     * <p>
     * The deprovisioned pool CIDR.
     * </p>
     * 
     * @return The deprovisioned pool CIDR.
     */
    public final IpamPoolCidr ipamPoolCidr() {
        return ipamPoolCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprovisionIpamPoolCidrResponse)) {
            return false;
        }
        DeprovisionIpamPoolCidrResponse other = (DeprovisionIpamPoolCidrResponse) obj;
        return Objects.equals(ipamPoolCidr(), other.ipamPoolCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprovisionIpamPoolCidrResponse").add("IpamPoolCidr", ipamPoolCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPoolCidr":
            return Optional.ofNullable(clazz.cast(ipamPoolCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeprovisionIpamPoolCidrResponse, T> g) {
        return obj -> g.apply((DeprovisionIpamPoolCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeprovisionIpamPoolCidrResponse> {
        /**
         * <p>
         * The deprovisioned pool CIDR.
         * </p>
         * 
         * @param ipamPoolCidr
         *        The deprovisioned pool CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolCidr(IpamPoolCidr ipamPoolCidr);

        /**
         * <p>
         * The deprovisioned pool CIDR.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPoolCidr.Builder} avoiding the need
         * to create one manually via {@link IpamPoolCidr#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPoolCidr.Builder#build()} is called immediately and its
         * result is passed to {@link #ipamPoolCidr(IpamPoolCidr)}.
         * 
         * @param ipamPoolCidr
         *        a consumer that will call methods on {@link IpamPoolCidr.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPoolCidr(IpamPoolCidr)
         */
        default Builder ipamPoolCidr(Consumer<IpamPoolCidr.Builder> ipamPoolCidr) {
            return ipamPoolCidr(IpamPoolCidr.builder().applyMutation(ipamPoolCidr).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPoolCidr ipamPoolCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprovisionIpamPoolCidrResponse model) {
            super(model);
            ipamPoolCidr(model.ipamPoolCidr);
        }

        public final IpamPoolCidr.Builder getIpamPoolCidr() {
            return ipamPoolCidr != null ? ipamPoolCidr.toBuilder() : null;
        }

        public final void setIpamPoolCidr(IpamPoolCidr.BuilderImpl ipamPoolCidr) {
            this.ipamPoolCidr = ipamPoolCidr != null ? ipamPoolCidr.build() : null;
        }

        @Override
        public final Builder ipamPoolCidr(IpamPoolCidr ipamPoolCidr) {
            this.ipamPoolCidr = ipamPoolCidr;
            return this;
        }

        @Override
        public DeprovisionIpamPoolCidrResponse build() {
            return new DeprovisionIpamPoolCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
