/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceConnectEndpointResponse extends Ec2Response implements
        ToCopyableBuilder<CreateInstanceConnectEndpointResponse.Builder, CreateInstanceConnectEndpointResponse> {
    private static final SdkField<Ec2InstanceConnectEndpoint> INSTANCE_CONNECT_ENDPOINT_FIELD = SdkField
            .<Ec2InstanceConnectEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceConnectEndpoint")
            .getter(getter(CreateInstanceConnectEndpointResponse::instanceConnectEndpoint))
            .setter(setter(Builder::instanceConnectEndpoint))
            .constructor(Ec2InstanceConnectEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpoint")
                    .unmarshallLocationName("instanceConnectEndpoint").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateInstanceConnectEndpointResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_CONNECT_ENDPOINT_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceConnectEndpoint", INSTANCE_CONNECT_ENDPOINT_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final Ec2InstanceConnectEndpoint instanceConnectEndpoint;

    private final String clientToken;

    private CreateInstanceConnectEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.instanceConnectEndpoint = builder.instanceConnectEndpoint;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @return Information about the EC2 Instance Connect Endpoint.
     */
    public final Ec2InstanceConnectEndpoint instanceConnectEndpoint() {
        return instanceConnectEndpoint;
    }

    /**
     * <p>
     * Unique, case-sensitive idempotency token provided by the client in the the request.
     * </p>
     * 
     * @return Unique, case-sensitive idempotency token provided by the client in the the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceConnectEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceConnectEndpointResponse)) {
            return false;
        }
        CreateInstanceConnectEndpointResponse other = (CreateInstanceConnectEndpointResponse) obj;
        return Objects.equals(instanceConnectEndpoint(), other.instanceConnectEndpoint())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstanceConnectEndpointResponse")
                .add("InstanceConnectEndpoint", instanceConnectEndpoint()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceConnectEndpoint":
            return Optional.ofNullable(clazz.cast(instanceConnectEndpoint()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceConnectEndpointResponse, T> g) {
        return obj -> g.apply((CreateInstanceConnectEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInstanceConnectEndpointResponse> {
        /**
         * <p>
         * Information about the EC2 Instance Connect Endpoint.
         * </p>
         * 
         * @param instanceConnectEndpoint
         *        Information about the EC2 Instance Connect Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConnectEndpoint(Ec2InstanceConnectEndpoint instanceConnectEndpoint);

        /**
         * <p>
         * Information about the EC2 Instance Connect Endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2InstanceConnectEndpoint.Builder}
         * avoiding the need to create one manually via {@link Ec2InstanceConnectEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2InstanceConnectEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceConnectEndpoint(Ec2InstanceConnectEndpoint)}.
         * 
         * @param instanceConnectEndpoint
         *        a consumer that will call methods on {@link Ec2InstanceConnectEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConnectEndpoint(Ec2InstanceConnectEndpoint)
         */
        default Builder instanceConnectEndpoint(Consumer<Ec2InstanceConnectEndpoint.Builder> instanceConnectEndpoint) {
            return instanceConnectEndpoint(Ec2InstanceConnectEndpoint.builder().applyMutation(instanceConnectEndpoint).build());
        }

        /**
         * <p>
         * Unique, case-sensitive idempotency token provided by the client in the the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive idempotency token provided by the client in the the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Ec2InstanceConnectEndpoint instanceConnectEndpoint;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceConnectEndpointResponse model) {
            super(model);
            instanceConnectEndpoint(model.instanceConnectEndpoint);
            clientToken(model.clientToken);
        }

        public final Ec2InstanceConnectEndpoint.Builder getInstanceConnectEndpoint() {
            return instanceConnectEndpoint != null ? instanceConnectEndpoint.toBuilder() : null;
        }

        public final void setInstanceConnectEndpoint(Ec2InstanceConnectEndpoint.BuilderImpl instanceConnectEndpoint) {
            this.instanceConnectEndpoint = instanceConnectEndpoint != null ? instanceConnectEndpoint.build() : null;
        }

        @Override
        public final Builder instanceConnectEndpoint(Ec2InstanceConnectEndpoint instanceConnectEndpoint) {
            this.instanceConnectEndpoint = instanceConnectEndpoint;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateInstanceConnectEndpointResponse build() {
            return new CreateInstanceConnectEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
