/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot Fleet request that was not successfully canceled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotFleetRequestsErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelSpotFleetRequestsErrorItem.Builder, CancelSpotFleetRequestsErrorItem> {
    private static final SdkField<CancelSpotFleetRequestsError> ERROR_FIELD = SdkField
            .<CancelSpotFleetRequestsError> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(CancelSpotFleetRequestsErrorItem::error))
            .setter(setter(Builder::error))
            .constructor(CancelSpotFleetRequestsError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(CancelSpotFleetRequestsErrorItem::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            SPOT_FLEET_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Error", ERROR_FIELD);
                    put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final CancelSpotFleetRequestsError error;

    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsErrorItem(BuilderImpl builder) {
        this.error = builder.error;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public final CancelSpotFleetRequestsError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsErrorItem)) {
            return false;
        }
        CancelSpotFleetRequestsErrorItem other = (CancelSpotFleetRequestsErrorItem) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelSpotFleetRequestsErrorItem").add("Error", error())
                .add("SpotFleetRequestId", spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsErrorItem, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelSpotFleetRequestsErrorItem> {
        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(CancelSpotFleetRequestsError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience method that creates an instance of the {@link CancelSpotFleetRequestsError.Builder}
         * avoiding the need to create one manually via {@link CancelSpotFleetRequestsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CancelSpotFleetRequestsError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(CancelSpotFleetRequestsError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link CancelSpotFleetRequestsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(CancelSpotFleetRequestsError)
         */
        default Builder error(Consumer<CancelSpotFleetRequestsError.Builder> error) {
            return error(CancelSpotFleetRequestsError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl implements Builder {
        private CancelSpotFleetRequestsError error;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsErrorItem model) {
            error(model.error);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final CancelSpotFleetRequestsError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(CancelSpotFleetRequestsError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(CancelSpotFleetRequestsError error) {
            this.error = error;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        @Override
        public CancelSpotFleetRequestsErrorItem build() {
            return new CancelSpotFleetRequestsErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
