/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an additional detail for a path analysis. For more information, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/reachability/additional-detail-codes.html">Reachability Analyzer
 * additional detail codes</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalDetail.Builder, AdditionalDetail> {
    private static final SdkField<String> ADDITIONAL_DETAIL_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AdditionalDetailType")
            .getter(getter(AdditionalDetail::additionalDetailType))
            .setter(setter(Builder::additionalDetailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetailType")
                    .unmarshallLocationName("additionalDetailType").build()).build();

    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Component")
            .getter(getter(AdditionalDetail::component))
            .setter(setter(Builder::component))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component")
                    .unmarshallLocationName("component").build()).build();

    private static final SdkField<AnalysisComponent> VPC_ENDPOINT_SERVICE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("VpcEndpointService")
            .getter(getter(AdditionalDetail::vpcEndpointService))
            .setter(setter(Builder::vpcEndpointService))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointService")
                    .unmarshallLocationName("vpcEndpointService").build()).build();

    private static final SdkField<List<RuleOption>> RULE_OPTIONS_FIELD = SdkField
            .<List<RuleOption>> builder(MarshallingType.LIST)
            .memberName("RuleOptions")
            .getter(getter(AdditionalDetail::ruleOptions))
            .setter(setter(Builder::ruleOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptionSet")
                    .unmarshallLocationName("ruleOptionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RuleOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<RuleGroupTypePair>> RULE_GROUP_TYPE_PAIRS_FIELD = SdkField
            .<List<RuleGroupTypePair>> builder(MarshallingType.LIST)
            .memberName("RuleGroupTypePairs")
            .getter(getter(AdditionalDetail::ruleGroupTypePairs))
            .setter(setter(Builder::ruleGroupTypePairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupTypePairSet")
                    .unmarshallLocationName("ruleGroupTypePairSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RuleGroupTypePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupTypePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<RuleGroupRuleOptionsPair>> RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD = SdkField
            .<List<RuleGroupRuleOptionsPair>> builder(MarshallingType.LIST)
            .memberName("RuleGroupRuleOptionsPairs")
            .getter(getter(AdditionalDetail::ruleGroupRuleOptionsPairs))
            .setter(setter(Builder::ruleGroupRuleOptionsPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRuleOptionsPairSet")
                    .unmarshallLocationName("ruleGroupRuleOptionsPairSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RuleGroupRuleOptionsPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupRuleOptionsPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceName")
            .getter(getter(AdditionalDetail::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName")
                    .unmarshallLocationName("serviceName").build()).build();

    private static final SdkField<List<AnalysisComponent>> LOAD_BALANCERS_FIELD = SdkField
            .<List<AnalysisComponent>> builder(MarshallingType.LIST)
            .memberName("LoadBalancers")
            .getter(getter(AdditionalDetail::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerSet")
                    .unmarshallLocationName("loadBalancerSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AnalysisComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_DETAIL_TYPE_FIELD,
            COMPONENT_FIELD, VPC_ENDPOINT_SERVICE_FIELD, RULE_OPTIONS_FIELD, RULE_GROUP_TYPE_PAIRS_FIELD,
            RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD, SERVICE_NAME_FIELD, LOAD_BALANCERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AdditionalDetailType", ADDITIONAL_DETAIL_TYPE_FIELD);
                    put("Component", COMPONENT_FIELD);
                    put("VpcEndpointService", VPC_ENDPOINT_SERVICE_FIELD);
                    put("RuleOptionSet", RULE_OPTIONS_FIELD);
                    put("RuleGroupTypePairSet", RULE_GROUP_TYPE_PAIRS_FIELD);
                    put("RuleGroupRuleOptionsPairSet", RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD);
                    put("ServiceName", SERVICE_NAME_FIELD);
                    put("LoadBalancerSet", LOAD_BALANCERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String additionalDetailType;

    private final AnalysisComponent component;

    private final AnalysisComponent vpcEndpointService;

    private final List<RuleOption> ruleOptions;

    private final List<RuleGroupTypePair> ruleGroupTypePairs;

    private final List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs;

    private final String serviceName;

    private final List<AnalysisComponent> loadBalancers;

    private AdditionalDetail(BuilderImpl builder) {
        this.additionalDetailType = builder.additionalDetailType;
        this.component = builder.component;
        this.vpcEndpointService = builder.vpcEndpointService;
        this.ruleOptions = builder.ruleOptions;
        this.ruleGroupTypePairs = builder.ruleGroupTypePairs;
        this.ruleGroupRuleOptionsPairs = builder.ruleGroupRuleOptionsPairs;
        this.serviceName = builder.serviceName;
        this.loadBalancers = builder.loadBalancers;
    }

    /**
     * <p>
     * The additional detail code.
     * </p>
     * 
     * @return The additional detail code.
     */
    public final String additionalDetailType() {
        return additionalDetailType;
    }

    /**
     * <p>
     * The path component.
     * </p>
     * 
     * @return The path component.
     */
    public final AnalysisComponent component() {
        return component;
    }

    /**
     * <p>
     * The VPC endpoint service.
     * </p>
     * 
     * @return The VPC endpoint service.
     */
    public final AnalysisComponent vpcEndpointService() {
        return vpcEndpointService;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleOptions() {
        return ruleOptions != null && !(ruleOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleOptions} method.
     * </p>
     * 
     * @return The rule options.
     */
    public final List<RuleOption> ruleOptions() {
        return ruleOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupTypePairs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleGroupTypePairs() {
        return ruleGroupTypePairs != null && !(ruleGroupTypePairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule group type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupTypePairs} method.
     * </p>
     * 
     * @return The rule group type.
     */
    public final List<RuleGroupTypePair> ruleGroupTypePairs() {
        return ruleGroupTypePairs;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupRuleOptionsPairs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRuleGroupRuleOptionsPairs() {
        return ruleGroupRuleOptionsPairs != null && !(ruleGroupRuleOptionsPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupRuleOptionsPairs} method.
     * </p>
     * 
     * @return The rule options.
     */
    public final List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs() {
        return ruleGroupRuleOptionsPairs;
    }

    /**
     * <p>
     * The name of the VPC endpoint service.
     * </p>
     * 
     * @return The name of the VPC endpoint service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return The load balancers.
     */
    public final List<AnalysisComponent> loadBalancers() {
        return loadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalDetailType());
        hashCode = 31 * hashCode + Objects.hashCode(component());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleOptions() ? ruleOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupTypePairs() ? ruleGroupTypePairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupRuleOptionsPairs() ? ruleGroupRuleOptionsPairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalDetail)) {
            return false;
        }
        AdditionalDetail other = (AdditionalDetail) obj;
        return Objects.equals(additionalDetailType(), other.additionalDetailType())
                && Objects.equals(component(), other.component())
                && Objects.equals(vpcEndpointService(), other.vpcEndpointService()) && hasRuleOptions() == other.hasRuleOptions()
                && Objects.equals(ruleOptions(), other.ruleOptions()) && hasRuleGroupTypePairs() == other.hasRuleGroupTypePairs()
                && Objects.equals(ruleGroupTypePairs(), other.ruleGroupTypePairs())
                && hasRuleGroupRuleOptionsPairs() == other.hasRuleGroupRuleOptionsPairs()
                && Objects.equals(ruleGroupRuleOptionsPairs(), other.ruleGroupRuleOptionsPairs())
                && Objects.equals(serviceName(), other.serviceName()) && hasLoadBalancers() == other.hasLoadBalancers()
                && Objects.equals(loadBalancers(), other.loadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalDetail").add("AdditionalDetailType", additionalDetailType())
                .add("Component", component()).add("VpcEndpointService", vpcEndpointService())
                .add("RuleOptions", hasRuleOptions() ? ruleOptions() : null)
                .add("RuleGroupTypePairs", hasRuleGroupTypePairs() ? ruleGroupTypePairs() : null)
                .add("RuleGroupRuleOptionsPairs", hasRuleGroupRuleOptionsPairs() ? ruleGroupRuleOptionsPairs() : null)
                .add("ServiceName", serviceName()).add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalDetailType":
            return Optional.ofNullable(clazz.cast(additionalDetailType()));
        case "Component":
            return Optional.ofNullable(clazz.cast(component()));
        case "VpcEndpointService":
            return Optional.ofNullable(clazz.cast(vpcEndpointService()));
        case "RuleOptions":
            return Optional.ofNullable(clazz.cast(ruleOptions()));
        case "RuleGroupTypePairs":
            return Optional.ofNullable(clazz.cast(ruleGroupTypePairs()));
        case "RuleGroupRuleOptionsPairs":
            return Optional.ofNullable(clazz.cast(ruleGroupRuleOptionsPairs()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "LoadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalDetail, T> g) {
        return obj -> g.apply((AdditionalDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalDetail> {
        /**
         * <p>
         * The additional detail code.
         * </p>
         * 
         * @param additionalDetailType
         *        The additional detail code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetailType(String additionalDetailType);

        /**
         * <p>
         * The path component.
         * </p>
         * 
         * @param component
         *        The path component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(AnalysisComponent component);

        /**
         * <p>
         * The path component.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #component(AnalysisComponent)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(AnalysisComponent)
         */
        default Builder component(Consumer<AnalysisComponent.Builder> component) {
            return component(AnalysisComponent.builder().applyMutation(component).build());
        }

        /**
         * <p>
         * The VPC endpoint service.
         * </p>
         * 
         * @param vpcEndpointService
         *        The VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointService(AnalysisComponent vpcEndpointService);

        /**
         * <p>
         * The VPC endpoint service.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcEndpointService(AnalysisComponent)}.
         * 
         * @param vpcEndpointService
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointService(AnalysisComponent)
         */
        default Builder vpcEndpointService(Consumer<AnalysisComponent.Builder> vpcEndpointService) {
            return vpcEndpointService(AnalysisComponent.builder().applyMutation(vpcEndpointService).build());
        }

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleOptions
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(Collection<RuleOption> ruleOptions);

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleOptions
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleOptions(RuleOption... ruleOptions);

        /**
         * <p>
         * The rule options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.RuleOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleOptions(List<RuleOption>)}.
         * 
         * @param ruleOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RuleOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleOptions(java.util.Collection<RuleOption>)
         */
        Builder ruleOptions(Consumer<RuleOption.Builder>... ruleOptions);

        /**
         * <p>
         * The rule group type.
         * </p>
         * 
         * @param ruleGroupTypePairs
         *        The rule group type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupTypePairs(Collection<RuleGroupTypePair> ruleGroupTypePairs);

        /**
         * <p>
         * The rule group type.
         * </p>
         * 
         * @param ruleGroupTypePairs
         *        The rule group type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupTypePairs(RuleGroupTypePair... ruleGroupTypePairs);

        /**
         * <p>
         * The rule group type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RuleGroupTypePair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RuleGroupTypePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RuleGroupTypePair.Builder#build()} is called immediately and
         * its result is passed to {@link #ruleGroupTypePairs(List<RuleGroupTypePair>)}.
         * 
         * @param ruleGroupTypePairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RuleGroupTypePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupTypePairs(java.util.Collection<RuleGroupTypePair>)
         */
        Builder ruleGroupTypePairs(Consumer<RuleGroupTypePair.Builder>... ruleGroupTypePairs);

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleGroupRuleOptionsPairs
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs);

        /**
         * <p>
         * The rule options.
         * </p>
         * 
         * @param ruleGroupRuleOptionsPairs
         *        The rule options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupRuleOptionsPairs(RuleGroupRuleOptionsPair... ruleGroupRuleOptionsPairs);

        /**
         * <p>
         * The rule options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroupRuleOptionsPairs(List<RuleGroupRuleOptionsPair>)}.
         * 
         * @param ruleGroupRuleOptionsPairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupRuleOptionsPairs(java.util.Collection<RuleGroupRuleOptionsPair>)
         */
        Builder ruleGroupRuleOptionsPairs(Consumer<RuleGroupRuleOptionsPair.Builder>... ruleGroupRuleOptionsPairs);

        /**
         * <p>
         * The name of the VPC endpoint service.
         * </p>
         * 
         * @param serviceName
         *        The name of the VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The load balancers.
         * </p>
         * 
         * @param loadBalancers
         *        The load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<AnalysisComponent> loadBalancers);

        /**
         * <p>
         * The load balancers.
         * </p>
         * 
         * @param loadBalancers
         *        The load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(AnalysisComponent... loadBalancers);

        /**
         * <p>
         * The load balancers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AnalysisComponent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AnalysisComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AnalysisComponent.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancers(List<AnalysisComponent>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<AnalysisComponent>)
         */
        Builder loadBalancers(Consumer<AnalysisComponent.Builder>... loadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private String additionalDetailType;

        private AnalysisComponent component;

        private AnalysisComponent vpcEndpointService;

        private List<RuleOption> ruleOptions = DefaultSdkAutoConstructList.getInstance();

        private List<RuleGroupTypePair> ruleGroupTypePairs = DefaultSdkAutoConstructList.getInstance();

        private List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs = DefaultSdkAutoConstructList.getInstance();

        private String serviceName;

        private List<AnalysisComponent> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalDetail model) {
            additionalDetailType(model.additionalDetailType);
            component(model.component);
            vpcEndpointService(model.vpcEndpointService);
            ruleOptions(model.ruleOptions);
            ruleGroupTypePairs(model.ruleGroupTypePairs);
            ruleGroupRuleOptionsPairs(model.ruleGroupRuleOptionsPairs);
            serviceName(model.serviceName);
            loadBalancers(model.loadBalancers);
        }

        public final String getAdditionalDetailType() {
            return additionalDetailType;
        }

        public final void setAdditionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
        }

        @Override
        public final Builder additionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final AnalysisComponent.Builder getVpcEndpointService() {
            return vpcEndpointService != null ? vpcEndpointService.toBuilder() : null;
        }

        public final void setVpcEndpointService(AnalysisComponent.BuilderImpl vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService != null ? vpcEndpointService.build() : null;
        }

        @Override
        public final Builder vpcEndpointService(AnalysisComponent vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService;
            return this;
        }

        public final List<RuleOption.Builder> getRuleOptions() {
            List<RuleOption.Builder> result = RuleOptionListCopier.copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleOption.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        public final Builder ruleOptions(Collection<RuleOption> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(RuleOption... ruleOptions) {
            ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleOption.Builder>... ruleOptions) {
            ruleOptions(Stream.of(ruleOptions).map(c -> RuleOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupTypePair.Builder> getRuleGroupTypePairs() {
            List<RuleGroupTypePair.Builder> result = RuleGroupTypePairListCopier.copyToBuilder(this.ruleGroupTypePairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroupTypePairs(Collection<RuleGroupTypePair.BuilderImpl> ruleGroupTypePairs) {
            this.ruleGroupTypePairs = RuleGroupTypePairListCopier.copyFromBuilder(ruleGroupTypePairs);
        }

        @Override
        public final Builder ruleGroupTypePairs(Collection<RuleGroupTypePair> ruleGroupTypePairs) {
            this.ruleGroupTypePairs = RuleGroupTypePairListCopier.copy(ruleGroupTypePairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupTypePairs(RuleGroupTypePair... ruleGroupTypePairs) {
            ruleGroupTypePairs(Arrays.asList(ruleGroupTypePairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupTypePairs(Consumer<RuleGroupTypePair.Builder>... ruleGroupTypePairs) {
            ruleGroupTypePairs(Stream.of(ruleGroupTypePairs).map(c -> RuleGroupTypePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupRuleOptionsPair.Builder> getRuleGroupRuleOptionsPairs() {
            List<RuleGroupRuleOptionsPair.Builder> result = RuleGroupRuleOptionsPairListCopier
                    .copyToBuilder(this.ruleGroupRuleOptionsPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair.BuilderImpl> ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs = RuleGroupRuleOptionsPairListCopier.copyFromBuilder(ruleGroupRuleOptionsPairs);
        }

        @Override
        public final Builder ruleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs = RuleGroupRuleOptionsPairListCopier.copy(ruleGroupRuleOptionsPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupRuleOptionsPairs(RuleGroupRuleOptionsPair... ruleGroupRuleOptionsPairs) {
            ruleGroupRuleOptionsPairs(Arrays.asList(ruleGroupRuleOptionsPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupRuleOptionsPairs(Consumer<RuleGroupRuleOptionsPair.Builder>... ruleGroupRuleOptionsPairs) {
            ruleGroupRuleOptionsPairs(Stream.of(ruleGroupRuleOptionsPairs)
                    .map(c -> RuleGroupRuleOptionsPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final List<AnalysisComponent.Builder> getLoadBalancers() {
            List<AnalysisComponent.Builder> result = AnalysisComponentListCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<AnalysisComponent.BuilderImpl> loadBalancers) {
            this.loadBalancers = AnalysisComponentListCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<AnalysisComponent> loadBalancers) {
            this.loadBalancers = AnalysisComponentListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(AnalysisComponent... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<AnalysisComponent.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> AnalysisComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AdditionalDetail build() {
            return new AdditionalDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
