/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BillingProductListCopier;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.BootModeValues;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImdsSupportValues;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TpmSupportValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterImageRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RegisterImageRequest> {
    private static final SdkField<String> IMAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageLocation").getter(RegisterImageRequest.getter(RegisterImageRequest::imageLocation)).setter(RegisterImageRequest.setter(Builder::imageLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLocation").unmarshallLocationName("ImageLocation").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(RegisterImageRequest.getter(RegisterImageRequest::architectureAsString)).setter(RegisterImageRequest.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("architecture").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(RegisterImageRequest.getter(RegisterImageRequest::blockDeviceMappings)).setter(RegisterImageRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RegisterImageRequest.getter(RegisterImageRequest::description)).setter(RegisterImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(RegisterImageRequest.getter(RegisterImageRequest::dryRun)).setter(RegisterImageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnaSupport").getter(RegisterImageRequest.getter(RegisterImageRequest::enaSupport)).setter(RegisterImageRequest.setter(Builder::enaSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(RegisterImageRequest.getter(RegisterImageRequest::kernelId)).setter(RegisterImageRequest.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegisterImageRequest.getter(RegisterImageRequest::name)).setter(RegisterImageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<List<String>> BILLING_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BillingProducts").getter(RegisterImageRequest.getter(RegisterImageRequest::billingProducts)).setter(RegisterImageRequest.setter(Builder::billingProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingProduct").unmarshallLocationName("BillingProduct").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(RegisterImageRequest.getter(RegisterImageRequest::ramdiskId)).setter(RegisterImageRequest.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("ramdiskId").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootDeviceName").getter(RegisterImageRequest.getter(RegisterImageRequest::rootDeviceName)).setter(RegisterImageRequest.setter(Builder::rootDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName").unmarshallLocationName("rootDeviceName").build()}).build();
    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SriovNetSupport").getter(RegisterImageRequest.getter(RegisterImageRequest::sriovNetSupport)).setter(RegisterImageRequest.setter(Builder::sriovNetSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualizationType").getter(RegisterImageRequest.getter(RegisterImageRequest::virtualizationType)).setter(RegisterImageRequest.setter(Builder::virtualizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").unmarshallLocationName("virtualizationType").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BootMode").getter(RegisterImageRequest.getter(RegisterImageRequest::bootModeAsString)).setter(RegisterImageRequest.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode").unmarshallLocationName("BootMode").build()}).build();
    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TpmSupport").getter(RegisterImageRequest.getter(RegisterImageRequest::tpmSupportAsString)).setter(RegisterImageRequest.setter(Builder::tpmSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport").unmarshallLocationName("TpmSupport").build()}).build();
    private static final SdkField<String> UEFI_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UefiData").getter(RegisterImageRequest.getter(RegisterImageRequest::uefiData)).setter(RegisterImageRequest.setter(Builder::uefiData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData").unmarshallLocationName("UefiData").build()}).build();
    private static final SdkField<String> IMDS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImdsSupport").getter(RegisterImageRequest.getter(RegisterImageRequest::imdsSupportAsString)).setter(RegisterImageRequest.setter(Builder::imdsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport").unmarshallLocationName("ImdsSupport").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(RegisterImageRequest.getter(RegisterImageRequest::tagSpecifications)).setter(RegisterImageRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_LOCATION_FIELD, ARCHITECTURE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, ENA_SUPPORT_FIELD, KERNEL_ID_FIELD, NAME_FIELD, BILLING_PRODUCTS_FIELD, RAMDISK_ID_FIELD, ROOT_DEVICE_NAME_FIELD, SRIOV_NET_SUPPORT_FIELD, VIRTUALIZATION_TYPE_FIELD, BOOT_MODE_FIELD, TPM_SUPPORT_FIELD, UEFI_DATA_FIELD, IMDS_SUPPORT_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String imageLocation;
    private final String architecture;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final Boolean dryRun;
    private final Boolean enaSupport;
    private final String kernelId;
    private final String name;
    private final List<String> billingProducts;
    private final String ramdiskId;
    private final String rootDeviceName;
    private final String sriovNetSupport;
    private final String virtualizationType;
    private final String bootMode;
    private final String tpmSupport;
    private final String uefiData;
    private final String imdsSupport;
    private final List<TagSpecification> tagSpecifications;

    private RegisterImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageLocation = builder.imageLocation;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.enaSupport = builder.enaSupport;
        this.kernelId = builder.kernelId;
        this.name = builder.name;
        this.billingProducts = builder.billingProducts;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.virtualizationType = builder.virtualizationType;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.uefiData = builder.uefiData;
        this.imdsSupport = builder.imdsSupport;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String imageLocation() {
        return this.imageLocation;
    }

    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean enaSupport() {
        return this.enaSupport;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasBillingProducts() {
        return this.billingProducts != null && !(this.billingProducts instanceof SdkAutoConstructList);
    }

    public final List<String> billingProducts() {
        return this.billingProducts;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final String rootDeviceName() {
        return this.rootDeviceName;
    }

    public final String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public final String virtualizationType() {
        return this.virtualizationType;
    }

    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final TpmSupportValues tpmSupport() {
        return TpmSupportValues.fromValue(this.tpmSupport);
    }

    public final String tpmSupportAsString() {
        return this.tpmSupport;
    }

    public final String uefiData() {
        return this.uefiData;
    }

    public final ImdsSupportValues imdsSupport() {
        return ImdsSupportValues.fromValue(this.imdsSupport);
    }

    public final String imdsSupportAsString() {
        return this.imdsSupport;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingProducts() ? this.billingProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tpmSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uefiData());
        hashCode = 31 * hashCode + Objects.hashCode(this.imdsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest)((Object)obj);
        return Objects.equals(this.imageLocation(), other.imageLocation()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.name(), other.name()) && this.hasBillingProducts() == other.hasBillingProducts() && Objects.equals(this.billingProducts(), other.billingProducts()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.virtualizationType(), other.virtualizationType()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.tpmSupportAsString(), other.tpmSupportAsString()) && Objects.equals(this.uefiData(), other.uefiData()) && Objects.equals(this.imdsSupportAsString(), other.imdsSupportAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterImageRequest").add("ImageLocation", (Object)this.imageLocation()).add("Architecture", (Object)this.architectureAsString()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("EnaSupport", (Object)this.enaSupport()).add("KernelId", (Object)this.kernelId()).add("Name", (Object)this.name()).add("BillingProducts", this.hasBillingProducts() ? this.billingProducts() : null).add("RamdiskId", (Object)this.ramdiskId()).add("RootDeviceName", (Object)this.rootDeviceName()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("VirtualizationType", (Object)this.virtualizationType()).add("BootMode", (Object)this.bootModeAsString()).add("TpmSupport", (Object)this.tpmSupportAsString()).add("UefiData", (Object)this.uefiData()).add("ImdsSupport", (Object)this.imdsSupportAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageLocation": {
                return Optional.ofNullable(clazz.cast(this.imageLocation()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BillingProducts": {
                return Optional.ofNullable(clazz.cast(this.billingProducts()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "RootDeviceName": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceName()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "VirtualizationType": {
                return Optional.ofNullable(clazz.cast(this.virtualizationType()));
            }
            case "BootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "TpmSupport": {
                return Optional.ofNullable(clazz.cast(this.tpmSupportAsString()));
            }
            case "UefiData": {
                return Optional.ofNullable(clazz.cast(this.uefiData()));
            }
            case "ImdsSupport": {
                return Optional.ofNullable(clazz.cast(this.imdsSupportAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterImageRequest, T> g) {
        return obj -> g.apply((RegisterImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String imageLocation;
        private String architecture;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean dryRun;
        private Boolean enaSupport;
        private String kernelId;
        private String name;
        private List<String> billingProducts = DefaultSdkAutoConstructList.getInstance();
        private String ramdiskId;
        private String rootDeviceName;
        private String sriovNetSupport;
        private String virtualizationType;
        private String bootMode;
        private String tpmSupport;
        private String uefiData;
        private String imdsSupport;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterImageRequest model) {
            super(model);
            this.imageLocation(model.imageLocation);
            this.architecture(model.architecture);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.enaSupport(model.enaSupport);
            this.kernelId(model.kernelId);
            this.name(model.name);
            this.billingProducts(model.billingProducts);
            this.ramdiskId(model.ramdiskId);
            this.rootDeviceName(model.rootDeviceName);
            this.sriovNetSupport(model.sriovNetSupport);
            this.virtualizationType(model.virtualizationType);
            this.bootMode(model.bootMode);
            this.tpmSupport(model.tpmSupport);
            this.uefiData(model.uefiData);
            this.imdsSupport(model.imdsSupport);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getImageLocation() {
            return this.imageLocation;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getBillingProducts() {
            if (this.billingProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.billingProducts;
        }

        public final void setBillingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
        }

        @Override
        public final Builder billingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingProducts(String ... billingProducts) {
            this.billingProducts(Arrays.asList(billingProducts));
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getTpmSupport() {
            return this.tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        @Override
        public final Builder tpmSupport(TpmSupportValues tpmSupport) {
            this.tpmSupport(tpmSupport == null ? null : tpmSupport.toString());
            return this;
        }

        public final String getUefiData() {
            return this.uefiData;
        }

        public final void setUefiData(String uefiData) {
            this.uefiData = uefiData;
        }

        @Override
        public final Builder uefiData(String uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        public final String getImdsSupport() {
            return this.imdsSupport;
        }

        public final void setImdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
        }

        @Override
        public final Builder imdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        @Override
        public final Builder imdsSupport(ImdsSupportValues imdsSupport) {
            this.imdsSupport(imdsSupport == null ? null : imdsSupport.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterImageRequest build() {
            return new RegisterImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterImageRequest> {
        public Builder imageLocation(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder kernelId(String var1);

        public Builder name(String var1);

        public Builder billingProducts(Collection<String> var1);

        public Builder billingProducts(String ... var1);

        public Builder ramdiskId(String var1);

        public Builder rootDeviceName(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder virtualizationType(String var1);

        public Builder bootMode(String var1);

        public Builder bootMode(BootModeValues var1);

        public Builder tpmSupport(String var1);

        public Builder tpmSupport(TpmSupportValues var1);

        public Builder uefiData(String var1);

        public Builder imdsSupport(String var1);

        public Builder imdsSupport(ImdsSupportValues var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

