/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EkPubKeyFormat;
import software.amazon.awssdk.services.ec2.model.EkPubKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstanceTpmEkPubRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetInstanceTpmEkPubRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetInstanceTpmEkPubRequest.getter(GetInstanceTpmEkPubRequest::instanceId)).setter(GetInstanceTpmEkPubRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(GetInstanceTpmEkPubRequest.getter(GetInstanceTpmEkPubRequest::keyTypeAsString)).setter(GetInstanceTpmEkPubRequest.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").unmarshallLocationName("KeyType").build()}).build();
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormat").getter(GetInstanceTpmEkPubRequest.getter(GetInstanceTpmEkPubRequest::keyFormatAsString)).setter(GetInstanceTpmEkPubRequest.setter(Builder::keyFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFormat").unmarshallLocationName("KeyFormat").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetInstanceTpmEkPubRequest.getter(GetInstanceTpmEkPubRequest::dryRun)).setter(GetInstanceTpmEkPubRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, KEY_TYPE_FIELD, KEY_FORMAT_FIELD, DRY_RUN_FIELD));
    private final String instanceId;
    private final String keyType;
    private final String keyFormat;
    private final Boolean dryRun;

    private GetInstanceTpmEkPubRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.keyType = builder.keyType;
        this.keyFormat = builder.keyFormat;
        this.dryRun = builder.dryRun;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final EkPubKeyType keyType() {
        return EkPubKeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final EkPubKeyFormat keyFormat() {
        return EkPubKeyFormat.fromValue(this.keyFormat);
    }

    public final String keyFormatAsString() {
        return this.keyFormat;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceTpmEkPubRequest)) {
            return false;
        }
        GetInstanceTpmEkPubRequest other = (GetInstanceTpmEkPubRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.keyFormatAsString(), other.keyFormatAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstanceTpmEkPubRequest").add("InstanceId", (Object)this.instanceId()).add("KeyType", (Object)this.keyTypeAsString()).add("KeyFormat", (Object)this.keyFormatAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "KeyFormat": {
                return Optional.ofNullable(clazz.cast(this.keyFormatAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceTpmEkPubRequest, T> g) {
        return obj -> g.apply((GetInstanceTpmEkPubRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private String keyType;
        private String keyFormat;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceTpmEkPubRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.keyType(model.keyType);
            this.keyFormat(model.keyFormat);
            this.dryRun(model.dryRun);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(EkPubKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        @Override
        public final Builder keyFormat(EkPubKeyFormat keyFormat) {
            this.keyFormat(keyFormat == null ? null : keyFormat.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceTpmEkPubRequest build() {
            return new GetInstanceTpmEkPubRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstanceTpmEkPubRequest> {
        public Builder instanceId(String var1);

        public Builder keyType(String var1);

        public Builder keyType(EkPubKeyType var1);

        public Builder keyFormat(String var1);

        public Builder keyFormat(EkPubKeyFormat var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

