/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the type of a stateful rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupTypePair implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupTypePair.Builder, RuleGroupTypePair> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn")
            .getter(getter(RuleGroupTypePair::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn")
                    .unmarshallLocationName("ruleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupType")
            .getter(getter(RuleGroupTypePair::ruleGroupType))
            .setter(setter(Builder::ruleGroupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupType")
                    .unmarshallLocationName("ruleGroupType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD,
            RULE_GROUP_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleGroupArn;

    private final String ruleGroupType;

    private RuleGroupTypePair(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupType = builder.ruleGroupType;
    }

    /**
     * <p>
     * The ARN of the rule group.
     * </p>
     * 
     * @return The ARN of the rule group.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * <p>
     * The rule group type. The possible values are <code>Domain List</code> and <code>Suricata</code>.
     * </p>
     * 
     * @return The rule group type. The possible values are <code>Domain List</code> and <code>Suricata</code>.
     */
    public final String ruleGroupType() {
        return ruleGroupType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupTypePair)) {
            return false;
        }
        RuleGroupTypePair other = (RuleGroupTypePair) obj;
        return Objects.equals(ruleGroupArn(), other.ruleGroupArn()) && Objects.equals(ruleGroupType(), other.ruleGroupType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupTypePair").add("RuleGroupArn", ruleGroupArn()).add("RuleGroupType", ruleGroupType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleGroupType":
            return Optional.ofNullable(clazz.cast(ruleGroupType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupTypePair, T> g) {
        return obj -> g.apply((RuleGroupTypePair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupTypePair> {
        /**
         * <p>
         * The ARN of the rule group.
         * </p>
         * 
         * @param ruleGroupArn
         *        The ARN of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The rule group type. The possible values are <code>Domain List</code> and <code>Suricata</code>.
         * </p>
         * 
         * @param ruleGroupType
         *        The rule group type. The possible values are <code>Domain List</code> and <code>Suricata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupType(String ruleGroupType);
    }

    static final class BuilderImpl implements Builder {
        private String ruleGroupArn;

        private String ruleGroupType;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupTypePair model) {
            ruleGroupArn(model.ruleGroupArn);
            ruleGroupType(model.ruleGroupType);
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupType() {
            return ruleGroupType;
        }

        public final void setRuleGroupType(String ruleGroupType) {
            this.ruleGroupType = ruleGroupType;
        }

        @Override
        public final Builder ruleGroupType(String ruleGroupType) {
            this.ruleGroupType = ruleGroupType;
            return this;
        }

        @Override
        public RuleGroupTypePair build() {
            return new RuleGroupTypePair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
