/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAwsNetworkPerformanceDataRequest extends Ec2Request implements
        ToCopyableBuilder<GetAwsNetworkPerformanceDataRequest.Builder, GetAwsNetworkPerformanceDataRequest> {
    private static final SdkField<List<DataQuery>> DATA_QUERIES_FIELD = SdkField
            .<List<DataQuery>> builder(MarshallingType.LIST)
            .memberName("DataQueries")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::dataQueries))
            .setter(setter(Builder::dataQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQuery")
                    .unmarshallLocationName("DataQuery").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(GetAwsNetworkPerformanceDataRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QUERIES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DRY_RUN_FIELD));

    private final List<DataQuery> dataQueries;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean dryRun;

    private GetAwsNetworkPerformanceDataRequest(BuilderImpl builder) {
        super(builder);
        this.dataQueries = builder.dataQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataQueries() {
        return dataQueries != null && !(dataQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of network performance data queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataQueries} method.
     * </p>
     * 
     * @return A list of network performance data queries.
     */
    public final List<DataQuery> dataQueries() {
        return dataQueries;
    }

    /**
     * <p>
     * The starting time for the performance data request. The starting time must be formatted as
     * <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-10T12:00:00.000Z</code>.
     * </p>
     * 
     * @return The starting time for the performance data request. The starting time must be formatted as
     *         <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-10T12:00:00.000Z</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The ending time for the performance data request. The end time must be formatted as
     * <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-12T12:00:00.000Z</code>.
     * </p>
     * 
     * @return The ending time for the performance data request. The end time must be formatted as
     *         <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-12T12:00:00.000Z</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataQueries() ? dataQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAwsNetworkPerformanceDataRequest)) {
            return false;
        }
        GetAwsNetworkPerformanceDataRequest other = (GetAwsNetworkPerformanceDataRequest) obj;
        return hasDataQueries() == other.hasDataQueries() && Objects.equals(dataQueries(), other.dataQueries())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAwsNetworkPerformanceDataRequest")
                .add("DataQueries", hasDataQueries() ? dataQueries() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("MaxResults", maxResults()).add("NextToken", nextToken()).add("DryRun", dryRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataQueries":
            return Optional.ofNullable(clazz.cast(dataQueries()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAwsNetworkPerformanceDataRequest, T> g) {
        return obj -> g.apply((GetAwsNetworkPerformanceDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetAwsNetworkPerformanceDataRequest> {
        /**
         * <p>
         * A list of network performance data queries.
         * </p>
         * 
         * @param dataQueries
         *        A list of network performance data queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQueries(Collection<DataQuery> dataQueries);

        /**
         * <p>
         * A list of network performance data queries.
         * </p>
         * 
         * @param dataQueries
         *        A list of network performance data queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQueries(DataQuery... dataQueries);

        /**
         * <p>
         * A list of network performance data queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DataQuery.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.DataQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DataQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #dataQueries(List<DataQuery>)}.
         * 
         * @param dataQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DataQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQueries(java.util.Collection<DataQuery>)
         */
        Builder dataQueries(Consumer<DataQuery.Builder>... dataQueries);

        /**
         * <p>
         * The starting time for the performance data request. The starting time must be formatted as
         * <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-10T12:00:00.000Z</code>.
         * </p>
         * 
         * @param startTime
         *        The starting time for the performance data request. The starting time must be formatted as
         *        <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-10T12:00:00.000Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The ending time for the performance data request. The end time must be formatted as
         * <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-12T12:00:00.000Z</code>.
         * </p>
         * 
         * @param endTime
         *        The ending time for the performance data request. The end time must be formatted as
         *        <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2022-06-12T12:00:00.000Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<DataQuery> dataQueries = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAwsNetworkPerformanceDataRequest model) {
            super(model);
            dataQueries(model.dataQueries);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            dryRun(model.dryRun);
        }

        public final List<DataQuery.Builder> getDataQueries() {
            List<DataQuery.Builder> result = DataQueriesCopier.copyToBuilder(this.dataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataQueries(Collection<DataQuery.BuilderImpl> dataQueries) {
            this.dataQueries = DataQueriesCopier.copyFromBuilder(dataQueries);
        }

        @Override
        public final Builder dataQueries(Collection<DataQuery> dataQueries) {
            this.dataQueries = DataQueriesCopier.copy(dataQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQueries(DataQuery... dataQueries) {
            dataQueries(Arrays.asList(dataQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQueries(Consumer<DataQuery.Builder>... dataQueries) {
            dataQueries(Stream.of(dataQueries).map(c -> DataQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAwsNetworkPerformanceDataRequest build() {
            return new GetAwsNetworkPerformanceDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
