/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskImage implements SdkPojo, Serializable, ToCopyableBuilder<DiskImage.Builder, DiskImage> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(DiskImage::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<DiskImageDetail> IMAGE_FIELD = SdkField
            .<DiskImageDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Image")
            .getter(getter(DiskImage::image))
            .setter(setter(Builder::image))
            .constructor(DiskImageDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image")
                    .unmarshallLocationName("Image").build()).build();

    private static final SdkField<VolumeDetail> VOLUME_FIELD = SdkField
            .<VolumeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Volume")
            .getter(getter(DiskImage::volume))
            .setter(setter(Builder::volume))
            .constructor(VolumeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume")
                    .unmarshallLocationName("Volume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            IMAGE_FIELD, VOLUME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final DiskImageDetail image;

    private final VolumeDetail volume;

    private DiskImage(BuilderImpl builder) {
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * A description of the disk image.
     * </p>
     * 
     * @return A description of the disk image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk image.
     * </p>
     * 
     * @return Information about the disk image.
     */
    public final DiskImageDetail image() {
        return image;
    }

    /**
     * <p>
     * Information about the volume.
     * </p>
     * 
     * @return Information about the volume.
     */
    public final VolumeDetail volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImage)) {
            return false;
        }
        DiskImage other = (DiskImage) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(image(), other.image())
                && Objects.equals(volume(), other.volume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiskImage").add("Description", description()).add("Image", image()).add("Volume", volume())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Volume":
            return Optional.ofNullable(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskImage, T> g) {
        return obj -> g.apply((DiskImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskImage> {
        /**
         * <p>
         * A description of the disk image.
         * </p>
         * 
         * @param description
         *        A description of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk image.
         * </p>
         * 
         * @param image
         *        Information about the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDetail image);

        /**
         * <p>
         * Information about the disk image.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskImageDetail.Builder} avoiding the
         * need to create one manually via {@link DiskImageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskImageDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #image(DiskImageDetail)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link DiskImageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(DiskImageDetail)
         */
        default Builder image(Consumer<DiskImageDetail.Builder> image) {
            return image(DiskImageDetail.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * Information about the volume.
         * </p>
         * 
         * @param volume
         *        Information about the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(VolumeDetail volume);

        /**
         * <p>
         * Information about the volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeDetail.Builder} avoiding the need
         * to create one manually via {@link VolumeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VolumeDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #volume(VolumeDetail)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link VolumeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(VolumeDetail)
         */
        default Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return volume(VolumeDetail.builder().applyMutation(volume).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private DiskImageDetail image;

        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImage model) {
            description(model.description);
            image(model.image);
            volume(model.volume);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DiskImageDetail.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final VolumeDetail.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public DiskImage build() {
            return new DiskImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
