/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Protocol;
import software.amazon.awssdk.services.ec2.model.ProtocolListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PacketHeaderStatementRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PacketHeaderStatementRequest> {
    private static final SdkField<List<String>> SOURCE_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAddresses").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::sourceAddresses)).setter(PacketHeaderStatementRequest.setter(Builder::sourceAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").unmarshallLocationName("SourceAddress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationAddresses").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::destinationAddresses)).setter(PacketHeaderStatementRequest.setter(Builder::destinationAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").unmarshallLocationName("DestinationAddress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePorts").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::sourcePorts)).setter(PacketHeaderStatementRequest.setter(Builder::sourcePorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").unmarshallLocationName("SourcePort").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPorts").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::destinationPorts)).setter(PacketHeaderStatementRequest.setter(Builder::destinationPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").unmarshallLocationName("DestinationPort").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_PREFIX_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePrefixLists").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::sourcePrefixLists)).setter(PacketHeaderStatementRequest.setter(Builder::sourcePrefixLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePrefixList").unmarshallLocationName("SourcePrefixList").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_PREFIX_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPrefixLists").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::destinationPrefixLists)).setter(PacketHeaderStatementRequest.setter(Builder::destinationPrefixLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixList").unmarshallLocationName("DestinationPrefixList").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(PacketHeaderStatementRequest.getter(PacketHeaderStatementRequest::protocolsAsStrings)).setter(PacketHeaderStatementRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESSES_FIELD, DESTINATION_ADDRESSES_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, SOURCE_PREFIX_LISTS_FIELD, DESTINATION_PREFIX_LISTS_FIELD, PROTOCOLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> sourceAddresses;
    private final List<String> destinationAddresses;
    private final List<String> sourcePorts;
    private final List<String> destinationPorts;
    private final List<String> sourcePrefixLists;
    private final List<String> destinationPrefixLists;
    private final List<String> protocols;

    private PacketHeaderStatementRequest(BuilderImpl builder) {
        this.sourceAddresses = builder.sourceAddresses;
        this.destinationAddresses = builder.destinationAddresses;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.sourcePrefixLists = builder.sourcePrefixLists;
        this.destinationPrefixLists = builder.destinationPrefixLists;
        this.protocols = builder.protocols;
    }

    public final boolean hasSourceAddresses() {
        return this.sourceAddresses != null && !(this.sourceAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public final boolean hasDestinationAddresses() {
        return this.destinationAddresses != null && !(this.destinationAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public final boolean hasSourcePorts() {
        return this.sourcePorts != null && !(this.sourcePorts instanceof SdkAutoConstructList);
    }

    public final List<String> sourcePorts() {
        return this.sourcePorts;
    }

    public final boolean hasDestinationPorts() {
        return this.destinationPorts != null && !(this.destinationPorts instanceof SdkAutoConstructList);
    }

    public final List<String> destinationPorts() {
        return this.destinationPorts;
    }

    public final boolean hasSourcePrefixLists() {
        return this.sourcePrefixLists != null && !(this.sourcePrefixLists instanceof SdkAutoConstructList);
    }

    public final List<String> sourcePrefixLists() {
        return this.sourcePrefixLists;
    }

    public final boolean hasDestinationPrefixLists() {
        return this.destinationPrefixLists != null && !(this.destinationPrefixLists instanceof SdkAutoConstructList);
    }

    public final List<String> destinationPrefixLists() {
        return this.destinationPrefixLists;
    }

    public final List<Protocol> protocols() {
        return ProtocolListCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAddresses() ? this.sourceAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationAddresses() ? this.destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePorts() ? this.sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPorts() ? this.destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePrefixLists() ? this.sourcePrefixLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPrefixLists() ? this.destinationPrefixLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PacketHeaderStatementRequest)) {
            return false;
        }
        PacketHeaderStatementRequest other = (PacketHeaderStatementRequest)obj;
        return this.hasSourceAddresses() == other.hasSourceAddresses() && Objects.equals(this.sourceAddresses(), other.sourceAddresses()) && this.hasDestinationAddresses() == other.hasDestinationAddresses() && Objects.equals(this.destinationAddresses(), other.destinationAddresses()) && this.hasSourcePorts() == other.hasSourcePorts() && Objects.equals(this.sourcePorts(), other.sourcePorts()) && this.hasDestinationPorts() == other.hasDestinationPorts() && Objects.equals(this.destinationPorts(), other.destinationPorts()) && this.hasSourcePrefixLists() == other.hasSourcePrefixLists() && Objects.equals(this.sourcePrefixLists(), other.sourcePrefixLists()) && this.hasDestinationPrefixLists() == other.hasDestinationPrefixLists() && Objects.equals(this.destinationPrefixLists(), other.destinationPrefixLists()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PacketHeaderStatementRequest").add("SourceAddresses", this.hasSourceAddresses() ? this.sourceAddresses() : null).add("DestinationAddresses", this.hasDestinationAddresses() ? this.destinationAddresses() : null).add("SourcePorts", this.hasSourcePorts() ? this.sourcePorts() : null).add("DestinationPorts", this.hasDestinationPorts() ? this.destinationPorts() : null).add("SourcePrefixLists", this.hasSourcePrefixLists() ? this.sourcePrefixLists() : null).add("DestinationPrefixLists", this.hasDestinationPrefixLists() ? this.destinationPrefixLists() : null).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAddresses": {
                return Optional.ofNullable(clazz.cast(this.sourceAddresses()));
            }
            case "DestinationAddresses": {
                return Optional.ofNullable(clazz.cast(this.destinationAddresses()));
            }
            case "SourcePorts": {
                return Optional.ofNullable(clazz.cast(this.sourcePorts()));
            }
            case "DestinationPorts": {
                return Optional.ofNullable(clazz.cast(this.destinationPorts()));
            }
            case "SourcePrefixLists": {
                return Optional.ofNullable(clazz.cast(this.sourcePrefixLists()));
            }
            case "DestinationPrefixLists": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixLists()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PacketHeaderStatementRequest, T> g) {
        return obj -> g.apply((PacketHeaderStatementRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sourceAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourcePorts = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationPorts = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourcePrefixLists = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationPrefixLists = DefaultSdkAutoConstructList.getInstance();
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PacketHeaderStatementRequest model) {
            this.sourceAddresses(model.sourceAddresses);
            this.destinationAddresses(model.destinationAddresses);
            this.sourcePorts(model.sourcePorts);
            this.destinationPorts(model.destinationPorts);
            this.sourcePrefixLists(model.sourcePrefixLists);
            this.destinationPrefixLists(model.destinationPrefixLists);
            this.protocolsWithStrings(model.protocols);
        }

        public final Collection<String> getSourceAddresses() {
            if (this.sourceAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceAddresses;
        }

        public final void setSourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = ValueStringListCopier.copy(sourceAddresses);
        }

        @Override
        public final Builder sourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = ValueStringListCopier.copy(sourceAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAddresses(String ... sourceAddresses) {
            this.sourceAddresses(Arrays.asList(sourceAddresses));
            return this;
        }

        public final Collection<String> getDestinationAddresses() {
            if (this.destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationAddresses;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = ValueStringListCopier.copy(destinationAddresses);
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = ValueStringListCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String ... destinationAddresses) {
            this.destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final Collection<String> getSourcePorts() {
            if (this.sourcePorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourcePorts;
        }

        public final void setSourcePorts(Collection<String> sourcePorts) {
            this.sourcePorts = ValueStringListCopier.copy(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<String> sourcePorts) {
            this.sourcePorts = ValueStringListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(String ... sourcePorts) {
            this.sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        public final Collection<String> getDestinationPorts() {
            if (this.destinationPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPorts;
        }

        public final void setDestinationPorts(Collection<String> destinationPorts) {
            this.destinationPorts = ValueStringListCopier.copy(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<String> destinationPorts) {
            this.destinationPorts = ValueStringListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(String ... destinationPorts) {
            this.destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        public final Collection<String> getSourcePrefixLists() {
            if (this.sourcePrefixLists instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourcePrefixLists;
        }

        public final void setSourcePrefixLists(Collection<String> sourcePrefixLists) {
            this.sourcePrefixLists = ValueStringListCopier.copy(sourcePrefixLists);
        }

        @Override
        public final Builder sourcePrefixLists(Collection<String> sourcePrefixLists) {
            this.sourcePrefixLists = ValueStringListCopier.copy(sourcePrefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePrefixLists(String ... sourcePrefixLists) {
            this.sourcePrefixLists(Arrays.asList(sourcePrefixLists));
            return this;
        }

        public final Collection<String> getDestinationPrefixLists() {
            if (this.destinationPrefixLists instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPrefixLists;
        }

        public final void setDestinationPrefixLists(Collection<String> destinationPrefixLists) {
            this.destinationPrefixLists = ValueStringListCopier.copy(destinationPrefixLists);
        }

        @Override
        public final Builder destinationPrefixLists(Collection<String> destinationPrefixLists) {
            this.destinationPrefixLists = ValueStringListCopier.copy(destinationPrefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPrefixLists(String ... destinationPrefixLists) {
            this.destinationPrefixLists(Arrays.asList(destinationPrefixLists));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public PacketHeaderStatementRequest build() {
            return new PacketHeaderStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PacketHeaderStatementRequest> {
        public Builder sourceAddresses(Collection<String> var1);

        public Builder sourceAddresses(String ... var1);

        public Builder destinationAddresses(Collection<String> var1);

        public Builder destinationAddresses(String ... var1);

        public Builder sourcePorts(Collection<String> var1);

        public Builder sourcePorts(String ... var1);

        public Builder destinationPorts(Collection<String> var1);

        public Builder destinationPorts(String ... var1);

        public Builder sourcePrefixLists(Collection<String> var1);

        public Builder sourcePrefixLists(String ... var1);

        public Builder destinationPrefixLists(Collection<String> var1);

        public Builder destinationPrefixLists(String ... var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);
    }
}

