/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupRule implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupRule.Builder, SecurityGroupRule> {
    private static final SdkField<String> SECURITY_GROUP_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupRuleId")
            .getter(getter(SecurityGroupRule::securityGroupRuleId))
            .setter(setter(Builder::securityGroupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId")
                    .unmarshallLocationName("securityGroupRuleId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(SecurityGroupRule::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupOwnerId")
            .getter(getter(SecurityGroupRule::groupOwnerId))
            .setter(setter(Builder::groupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwnerId")
                    .unmarshallLocationName("groupOwnerId").build()).build();

    private static final SdkField<Boolean> IS_EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEgress")
            .getter(getter(SecurityGroupRule::isEgress))
            .setter(setter(Builder::isEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEgress")
                    .unmarshallLocationName("isEgress").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(SecurityGroupRule::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(SecurityGroupRule::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(SecurityGroupRule::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<String> CIDR_IPV4_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv4")
            .getter(getter(SecurityGroupRule::cidrIpv4))
            .setter(setter(Builder::cidrIpv4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv4")
                    .unmarshallLocationName("cidrIpv4").build()).build();

    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv6")
            .getter(getter(SecurityGroupRule::cidrIpv6))
            .setter(setter(Builder::cidrIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6")
                    .unmarshallLocationName("cidrIpv6").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(SecurityGroupRule::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<ReferencedSecurityGroup> REFERENCED_GROUP_INFO_FIELD = SdkField
            .<ReferencedSecurityGroup> builder(MarshallingType.SDK_POJO)
            .memberName("ReferencedGroupInfo")
            .getter(getter(SecurityGroupRule::referencedGroupInfo))
            .setter(setter(Builder::referencedGroupInfo))
            .constructor(ReferencedSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedGroupInfo")
                    .unmarshallLocationName("referencedGroupInfo").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SecurityGroupRule::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SecurityGroupRule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULE_ID_FIELD,
            GROUP_ID_FIELD, GROUP_OWNER_ID_FIELD, IS_EGRESS_FIELD, IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD,
            CIDR_IPV4_FIELD, CIDR_IPV6_FIELD, PREFIX_LIST_ID_FIELD, REFERENCED_GROUP_INFO_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String securityGroupRuleId;

    private final String groupId;

    private final String groupOwnerId;

    private final Boolean isEgress;

    private final String ipProtocol;

    private final Integer fromPort;

    private final Integer toPort;

    private final String cidrIpv4;

    private final String cidrIpv6;

    private final String prefixListId;

    private final ReferencedSecurityGroup referencedGroupInfo;

    private final String description;

    private final List<Tag> tags;

    private SecurityGroupRule(BuilderImpl builder) {
        this.securityGroupRuleId = builder.securityGroupRuleId;
        this.groupId = builder.groupId;
        this.groupOwnerId = builder.groupOwnerId;
        this.isEgress = builder.isEgress;
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.cidrIpv4 = builder.cidrIpv4;
        this.cidrIpv6 = builder.cidrIpv6;
        this.prefixListId = builder.prefixListId;
        this.referencedGroupInfo = builder.referencedGroupInfo;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the security group rule.
     * </p>
     * 
     * @return The ID of the security group rule.
     */
    public final String securityGroupRuleId() {
        return securityGroupRuleId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the security group.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the security group.
     */
    public final String groupOwnerId() {
        return groupOwnerId;
    }

    /**
     * <p>
     * Indicates whether the security group rule is an outbound rule.
     * </p>
     * 
     * @return Indicates whether the security group rule is an outbound rule.
     */
    public final Boolean isEgress() {
        return isEgress;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see
     * <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     * </p>
     * <p>
     * Use <code>-1</code> to specify all protocols.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
     *         number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
     *         Numbers</a>). </p>
     *         <p>
     *         Use <code>-1</code> to specify all protocols.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6, this is
     * the ICMP type or -1 (all ICMP types).
     * </p>
     * 
     * @return If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6,
     *         this is the ICMP type or -1 (all ICMP types).
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this is the
     * ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all
     * ICMP codes).
     * </p>
     * 
     * @return If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this
     *         is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must
     *         be -1 (all ICMP codes).
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The IPv4 CIDR range.
     * </p>
     * 
     * @return The IPv4 CIDR range.
     */
    public final String cidrIpv4() {
        return cidrIpv4;
    }

    /**
     * <p>
     * The IPv6 CIDR range.
     * </p>
     * 
     * @return The IPv6 CIDR range.
     */
    public final String cidrIpv6() {
        return cidrIpv6;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * Describes the security group that is referenced in the rule.
     * </p>
     * 
     * @return Describes the security group that is referenced in the rule.
     */
    public final ReferencedSecurityGroup referencedGroupInfo() {
        return referencedGroupInfo;
    }

    /**
     * <p>
     * The security group rule description.
     * </p>
     * 
     * @return The security group rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags applied to the security group rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags applied to the security group rule.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(isEgress());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv4());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(referencedGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRule)) {
            return false;
        }
        SecurityGroupRule other = (SecurityGroupRule) obj;
        return Objects.equals(securityGroupRuleId(), other.securityGroupRuleId()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(groupOwnerId(), other.groupOwnerId()) && Objects.equals(isEgress(), other.isEgress())
                && Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(toPort(), other.toPort()) && Objects.equals(cidrIpv4(), other.cidrIpv4())
                && Objects.equals(cidrIpv6(), other.cidrIpv6()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(referencedGroupInfo(), other.referencedGroupInfo())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupRule").add("SecurityGroupRuleId", securityGroupRuleId()).add("GroupId", groupId())
                .add("GroupOwnerId", groupOwnerId()).add("IsEgress", isEgress()).add("IpProtocol", ipProtocol())
                .add("FromPort", fromPort()).add("ToPort", toPort()).add("CidrIpv4", cidrIpv4()).add("CidrIpv6", cidrIpv6())
                .add("PrefixListId", prefixListId()).add("ReferencedGroupInfo", referencedGroupInfo())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupRuleId":
            return Optional.ofNullable(clazz.cast(securityGroupRuleId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupOwnerId":
            return Optional.ofNullable(clazz.cast(groupOwnerId()));
        case "IsEgress":
            return Optional.ofNullable(clazz.cast(isEgress()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "CidrIpv4":
            return Optional.ofNullable(clazz.cast(cidrIpv4()));
        case "CidrIpv6":
            return Optional.ofNullable(clazz.cast(cidrIpv6()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "ReferencedGroupInfo":
            return Optional.ofNullable(clazz.cast(referencedGroupInfo()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRule, T> g) {
        return obj -> g.apply((SecurityGroupRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupRule> {
        /**
         * <p>
         * The ID of the security group rule.
         * </p>
         * 
         * @param securityGroupRuleId
         *        The ID of the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleId(String securityGroupRuleId);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the security group.
         * </p>
         * 
         * @param groupOwnerId
         *        The ID of the Amazon Web Services account that owns the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupOwnerId(String groupOwnerId);

        /**
         * <p>
         * Indicates whether the security group rule is an outbound rule.
         * </p>
         * 
         * @param isEgress
         *        Indicates whether the security group rule is an outbound rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEgress(Boolean isEgress);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         * </p>
         * <p>
         * Use <code>-1</code> to specify all protocols.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
         *        number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
         *        Numbers</a>). </p>
         *        <p>
         *        Use <code>-1</code> to specify all protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6, this
         * is the ICMP type or -1 (all ICMP types).
         * </p>
         * 
         * @param fromPort
         *        If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6,
         *        this is the ICMP type or -1 (all ICMP types).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this is
         * the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1
         * (all ICMP codes).
         * </p>
         * 
         * @param toPort
         *        If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6,
         *        this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end
         *        port must be -1 (all ICMP codes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The IPv4 CIDR range.
         * </p>
         * 
         * @param cidrIpv4
         *        The IPv4 CIDR range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv4(String cidrIpv4);

        /**
         * <p>
         * The IPv6 CIDR range.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * Describes the security group that is referenced in the rule.
         * </p>
         * 
         * @param referencedGroupInfo
         *        Describes the security group that is referenced in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedGroupInfo(ReferencedSecurityGroup referencedGroupInfo);

        /**
         * <p>
         * Describes the security group that is referenced in the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferencedSecurityGroup.Builder} avoiding
         * the need to create one manually via {@link ReferencedSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferencedSecurityGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #referencedGroupInfo(ReferencedSecurityGroup)}.
         * 
         * @param referencedGroupInfo
         *        a consumer that will call methods on {@link ReferencedSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referencedGroupInfo(ReferencedSecurityGroup)
         */
        default Builder referencedGroupInfo(Consumer<ReferencedSecurityGroup.Builder> referencedGroupInfo) {
            return referencedGroupInfo(ReferencedSecurityGroup.builder().applyMutation(referencedGroupInfo).build());
        }

        /**
         * <p>
         * The security group rule description.
         * </p>
         * 
         * @param description
         *        The security group rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * 
         * @param tags
         *        The tags applied to the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * 
         * @param tags
         *        The tags applied to the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags applied to the security group rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String securityGroupRuleId;

        private String groupId;

        private String groupOwnerId;

        private Boolean isEgress;

        private String ipProtocol;

        private Integer fromPort;

        private Integer toPort;

        private String cidrIpv4;

        private String cidrIpv6;

        private String prefixListId;

        private ReferencedSecurityGroup referencedGroupInfo;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRule model) {
            securityGroupRuleId(model.securityGroupRuleId);
            groupId(model.groupId);
            groupOwnerId(model.groupOwnerId);
            isEgress(model.isEgress);
            ipProtocol(model.ipProtocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
            cidrIpv4(model.cidrIpv4);
            cidrIpv6(model.cidrIpv6);
            prefixListId(model.prefixListId);
            referencedGroupInfo(model.referencedGroupInfo);
            description(model.description);
            tags(model.tags);
        }

        public final String getSecurityGroupRuleId() {
            return securityGroupRuleId;
        }

        public final void setSecurityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
        }

        @Override
        public final Builder securityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupOwnerId() {
            return groupOwnerId;
        }

        public final void setGroupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
        }

        @Override
        public final Builder groupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
            return this;
        }

        public final Boolean getIsEgress() {
            return isEgress;
        }

        public final void setIsEgress(Boolean isEgress) {
            this.isEgress = isEgress;
        }

        @Override
        public final Builder isEgress(Boolean isEgress) {
            this.isEgress = isEgress;
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getCidrIpv4() {
            return cidrIpv4;
        }

        public final void setCidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
        }

        @Override
        public final Builder cidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
            return this;
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final ReferencedSecurityGroup.Builder getReferencedGroupInfo() {
            return referencedGroupInfo != null ? referencedGroupInfo.toBuilder() : null;
        }

        public final void setReferencedGroupInfo(ReferencedSecurityGroup.BuilderImpl referencedGroupInfo) {
            this.referencedGroupInfo = referencedGroupInfo != null ? referencedGroupInfo.build() : null;
        }

        @Override
        public final Builder referencedGroupInfo(ReferencedSecurityGroup referencedGroupInfo) {
            this.referencedGroupInfo = referencedGroupInfo;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecurityGroupRule build() {
            return new SecurityGroupRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
