/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC with a security group that references your security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupReference implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupReference.Builder, SecurityGroupReference> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(SecurityGroupReference::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> REFERENCING_VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReferencingVpcId")
            .getter(getter(SecurityGroupReference::referencingVpcId))
            .setter(setter(Builder::referencingVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencingVpcId")
                    .unmarshallLocationName("referencingVpcId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(SecurityGroupReference::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(SecurityGroupReference::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            REFERENCING_VPC_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String referencingVpcId;

    private final String vpcPeeringConnectionId;

    private final String transitGatewayId;

    private SecurityGroupReference(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.referencingVpcId = builder.referencingVpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
    }

    /**
     * <p>
     * The ID of your security group.
     * </p>
     * 
     * @return The ID of your security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The ID of the VPC with the referencing security group.
     * </p>
     * 
     * @return The ID of the VPC with the referencing security group.
     */
    public final String referencingVpcId() {
        return referencingVpcId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection (if applicable). For more information about security group referencing for
     * peering connections, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html">Update your security
     * groups to reference peer security groups</a> in the <i>VPC Peering Guide</i>.
     * </p>
     * 
     * @return The ID of the VPC peering connection (if applicable). For more information about security group
     *         referencing for peering connections, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html">Update your
     *         security groups to reference peer security groups</a> in the <i>VPC Peering Guide</i>.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <note>
     * <p>
     * This parameter is in preview and may not be available for your account.
     * </p>
     * </note>
     * <p>
     * The ID of the transit gateway (if applicable).
     * </p>
     * 
     * @return <p>
     *         This parameter is in preview and may not be available for your account.
     *         </p>
     *         </note>
     *         <p>
     *         The ID of the transit gateway (if applicable).
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(referencingVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupReference)) {
            return false;
        }
        SecurityGroupReference other = (SecurityGroupReference) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(referencingVpcId(), other.referencingVpcId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupReference").add("GroupId", groupId()).add("ReferencingVpcId", referencingVpcId())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).add("TransitGatewayId", transitGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "ReferencingVpcId":
            return Optional.ofNullable(clazz.cast(referencingVpcId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupReference, T> g) {
        return obj -> g.apply((SecurityGroupReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupReference> {
        /**
         * <p>
         * The ID of your security group.
         * </p>
         * 
         * @param groupId
         *        The ID of your security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The ID of the VPC with the referencing security group.
         * </p>
         * 
         * @param referencingVpcId
         *        The ID of the VPC with the referencing security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencingVpcId(String referencingVpcId);

        /**
         * <p>
         * The ID of the VPC peering connection (if applicable). For more information about security group referencing
         * for peering connections, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html">Update your security
         * groups to reference peer security groups</a> in the <i>VPC Peering Guide</i>.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection (if applicable). For more information about security group
         *        referencing for peering connections, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html">Update your
         *        security groups to reference peer security groups</a> in the <i>VPC Peering Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <note>
         * <p>
         * This parameter is in preview and may not be available for your account.
         * </p>
         * </note>
         * <p>
         * The ID of the transit gateway (if applicable).
         * </p>
         * 
         * @param transitGatewayId
         *        <p>
         *        This parameter is in preview and may not be available for your account.
         *        </p>
         *        </note>
         *        <p>
         *        The ID of the transit gateway (if applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String referencingVpcId;

        private String vpcPeeringConnectionId;

        private String transitGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupReference model) {
            groupId(model.groupId);
            referencingVpcId(model.referencingVpcId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            transitGatewayId(model.transitGatewayId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getReferencingVpcId() {
            return referencingVpcId;
        }

        public final void setReferencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
        }

        @Override
        public final Builder referencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        @Override
        public SecurityGroupReference build() {
            return new SecurityGroupReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
