/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnect;

public class DescribeTransitGatewayConnectsIterable
implements SdkIterable<DescribeTransitGatewayConnectsResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayConnectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayConnectsIterable(Ec2Client client, DescribeTransitGatewayConnectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewayConnectsResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayConnectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayConnect> transitGatewayConnects() {
        Function<DescribeTransitGatewayConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayConnects() != null) {
                return response.transitGatewayConnects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayConnectsResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayConnectsResponse> {
        private DescribeTransitGatewayConnectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayConnectsResponse nextPage(DescribeTransitGatewayConnectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayConnectsIterable.this.client.describeTransitGatewayConnects(DescribeTransitGatewayConnectsIterable.this.firstRequest);
            }
            return DescribeTransitGatewayConnectsIterable.this.client.describeTransitGatewayConnects((DescribeTransitGatewayConnectsRequest)((Object)DescribeTransitGatewayConnectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

