/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InternetGateway;
import software.amazon.awssdk.services.ec2.model.InternetGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInternetGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
    private static final SdkField<List<InternetGateway>> INTERNET_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InternetGateways").getter(DescribeInternetGatewaysResponse.getter(DescribeInternetGatewaysResponse::internetGateways)).setter(DescribeInternetGatewaysResponse.setter(Builder::internetGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewaySet").unmarshallLocationName("internetGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InternetGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInternetGatewaysResponse.getter(DescribeInternetGatewaysResponse::nextToken)).setter(DescribeInternetGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InternetGateway> internetGateways;
    private final String nextToken;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.internetGateways = builder.internetGateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInternetGateways() {
        return this.internetGateways != null && !(this.internetGateways instanceof SdkAutoConstructList);
    }

    public final List<InternetGateway> internetGateways() {
        return this.internetGateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInternetGateways() ? this.internetGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse)((Object)obj);
        return this.hasInternetGateways() == other.hasInternetGateways() && Objects.equals(this.internetGateways(), other.internetGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInternetGatewaysResponse").add("InternetGateways", this.hasInternetGateways() ? this.internetGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InternetGateways": {
                return Optional.ofNullable(clazz.cast(this.internetGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInternetGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeInternetGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InternetGateway> internetGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            super(model);
            this.internetGateways(model.internetGateways);
            this.nextToken(model.nextToken);
        }

        public final List<InternetGateway.Builder> getInternetGateways() {
            List<InternetGateway.Builder> result = InternetGatewayListCopier.copyToBuilder(this.internetGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInternetGateways(Collection<InternetGateway.BuilderImpl> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copyFromBuilder(internetGateways);
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway ... internetGateways) {
            this.internetGateways(Arrays.asList(internetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(Consumer<InternetGateway.Builder> ... internetGateways) {
            this.internetGateways(Stream.of(internetGateways).map(c -> (InternetGateway)((InternetGateway.Builder)InternetGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        public Builder internetGateways(Collection<InternetGateway> var1);

        public Builder internetGateways(InternetGateway ... var1);

        public Builder internetGateways(Consumer<InternetGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

