/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddress;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddressSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamDiscoveredPublicAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamDiscoveredPublicAddressesResponse> {
    private static final SdkField<List<IpamDiscoveredPublicAddress>> IPAM_DISCOVERED_PUBLIC_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamDiscoveredPublicAddresses").getter(GetIpamDiscoveredPublicAddressesResponse.getter(GetIpamDiscoveredPublicAddressesResponse::ipamDiscoveredPublicAddresses)).setter(GetIpamDiscoveredPublicAddressesResponse.setter(Builder::ipamDiscoveredPublicAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamDiscoveredPublicAddressSet").unmarshallLocationName("ipamDiscoveredPublicAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamDiscoveredPublicAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> OLDEST_SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OldestSampleTime").getter(GetIpamDiscoveredPublicAddressesResponse.getter(GetIpamDiscoveredPublicAddressesResponse::oldestSampleTime)).setter(GetIpamDiscoveredPublicAddressesResponse.setter(Builder::oldestSampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldestSampleTime").unmarshallLocationName("oldestSampleTime").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamDiscoveredPublicAddressesResponse.getter(GetIpamDiscoveredPublicAddressesResponse::nextToken)).setter(GetIpamDiscoveredPublicAddressesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_DISCOVERED_PUBLIC_ADDRESSES_FIELD, OLDEST_SAMPLE_TIME_FIELD, NEXT_TOKEN_FIELD));
    private final List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses;
    private final Instant oldestSampleTime;
    private final String nextToken;

    private GetIpamDiscoveredPublicAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.ipamDiscoveredPublicAddresses = builder.ipamDiscoveredPublicAddresses;
        this.oldestSampleTime = builder.oldestSampleTime;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamDiscoveredPublicAddresses() {
        return this.ipamDiscoveredPublicAddresses != null && !(this.ipamDiscoveredPublicAddresses instanceof SdkAutoConstructList);
    }

    public final List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses() {
        return this.ipamDiscoveredPublicAddresses;
    }

    public final Instant oldestSampleTime() {
        return this.oldestSampleTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamDiscoveredPublicAddresses() ? this.ipamDiscoveredPublicAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.oldestSampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamDiscoveredPublicAddressesResponse)) {
            return false;
        }
        GetIpamDiscoveredPublicAddressesResponse other = (GetIpamDiscoveredPublicAddressesResponse)((Object)obj);
        return this.hasIpamDiscoveredPublicAddresses() == other.hasIpamDiscoveredPublicAddresses() && Objects.equals(this.ipamDiscoveredPublicAddresses(), other.ipamDiscoveredPublicAddresses()) && Objects.equals(this.oldestSampleTime(), other.oldestSampleTime()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamDiscoveredPublicAddressesResponse").add("IpamDiscoveredPublicAddresses", this.hasIpamDiscoveredPublicAddresses() ? this.ipamDiscoveredPublicAddresses() : null).add("OldestSampleTime", (Object)this.oldestSampleTime()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamDiscoveredPublicAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipamDiscoveredPublicAddresses()));
            }
            case "OldestSampleTime": {
                return Optional.ofNullable(clazz.cast(this.oldestSampleTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamDiscoveredPublicAddressesResponse, T> g) {
        return obj -> g.apply((GetIpamDiscoveredPublicAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses = DefaultSdkAutoConstructList.getInstance();
        private Instant oldestSampleTime;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamDiscoveredPublicAddressesResponse model) {
            super(model);
            this.ipamDiscoveredPublicAddresses(model.ipamDiscoveredPublicAddresses);
            this.oldestSampleTime(model.oldestSampleTime);
            this.nextToken(model.nextToken);
        }

        public final List<IpamDiscoveredPublicAddress.Builder> getIpamDiscoveredPublicAddresses() {
            List<IpamDiscoveredPublicAddress.Builder> result = IpamDiscoveredPublicAddressSetCopier.copyToBuilder(this.ipamDiscoveredPublicAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamDiscoveredPublicAddresses(Collection<IpamDiscoveredPublicAddress.BuilderImpl> ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses = IpamDiscoveredPublicAddressSetCopier.copyFromBuilder(ipamDiscoveredPublicAddresses);
        }

        @Override
        public final Builder ipamDiscoveredPublicAddresses(Collection<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses = IpamDiscoveredPublicAddressSetCopier.copy(ipamDiscoveredPublicAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredPublicAddresses(IpamDiscoveredPublicAddress ... ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses(Arrays.asList(ipamDiscoveredPublicAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredPublicAddresses(Consumer<IpamDiscoveredPublicAddress.Builder> ... ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses(Stream.of(ipamDiscoveredPublicAddresses).map(c -> (IpamDiscoveredPublicAddress)((IpamDiscoveredPublicAddress.Builder)IpamDiscoveredPublicAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getOldestSampleTime() {
            return this.oldestSampleTime;
        }

        public final void setOldestSampleTime(Instant oldestSampleTime) {
            this.oldestSampleTime = oldestSampleTime;
        }

        @Override
        public final Builder oldestSampleTime(Instant oldestSampleTime) {
            this.oldestSampleTime = oldestSampleTime;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamDiscoveredPublicAddressesResponse build() {
            return new GetIpamDiscoveredPublicAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamDiscoveredPublicAddressesResponse> {
        public Builder ipamDiscoveredPublicAddresses(Collection<IpamDiscoveredPublicAddress> var1);

        public Builder ipamDiscoveredPublicAddresses(IpamDiscoveredPublicAddress ... var1);

        public Builder ipamDiscoveredPublicAddresses(Consumer<IpamDiscoveredPublicAddress.Builder> ... var1);

        public Builder oldestSampleTime(Instant var1);

        public Builder nextToken(String var1);
    }
}

