/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetResponse extends Ec2Response implements
        ToCopyableBuilder<CreateFleetResponse.Builder, CreateFleetResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FleetId")
            .getter(getter(CreateFleetResponse::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("fleetId").build()).build();

    private static final SdkField<List<CreateFleetError>> ERRORS_FIELD = SdkField
            .<List<CreateFleetError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(CreateFleetResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorSet")
                    .unmarshallLocationName("errorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateFleetError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateFleetError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<CreateFleetInstance>> INSTANCES_FIELD = SdkField
            .<List<CreateFleetInstance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(CreateFleetResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetInstanceSet")
                    .unmarshallLocationName("fleetInstanceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateFleetInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateFleetInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ERRORS_FIELD,
            INSTANCES_FIELD));

    private final String fleetId;

    private final List<CreateFleetError> errors;

    private final List<CreateFleetInstance> instances;

    private CreateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.errors = builder.errors;
        this.instances = builder.instances;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances that could not be launched by the fleet. Supported only for fleets of type
     * <code>instant</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Information about the instances that could not be launched by the fleet. Supported only for fleets of
     *         type <code>instant</code>.
     */
    public final List<CreateFleetError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances that were launched by the fleet. Supported only for fleets of type
     * <code>instant</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return Information about the instances that were launched by the fleet. Supported only for fleets of type
     *         <code>instant</code>.
     */
    public final List<CreateFleetInstance> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse) obj;
        return Objects.equals(fleetId(), other.fleetId()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetResponse").add("FleetId", fleetId()).add("Errors", hasErrors() ? errors() : null)
                .add("Instances", hasInstances() ? instances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetResponse, T> g) {
        return obj -> g.apply((CreateFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetResponse> {
        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * 
         * @param errors
         *        Information about the instances that could not be launched by the fleet. Supported only for fleets of
         *        type <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<CreateFleetError> errors);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * 
         * @param errors
         *        Information about the instances that could not be launched by the fleet. Supported only for fleets of
         *        type <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(CreateFleetError... errors);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CreateFleetError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.CreateFleetError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CreateFleetError.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<CreateFleetError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CreateFleetError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<CreateFleetError>)
         */
        Builder errors(Consumer<CreateFleetError.Builder>... errors);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * 
         * @param instances
         *        Information about the instances that were launched by the fleet. Supported only for fleets of type
         *        <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<CreateFleetInstance> instances);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * 
         * @param instances
         *        Information about the instances that were launched by the fleet. Supported only for fleets of type
         *        <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(CreateFleetInstance... instances);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Supported only for fleets of type
         * <code>instant</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CreateFleetInstance.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.CreateFleetInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CreateFleetInstance.Builder#build()} is called immediately
         * and its result is passed to {@link #instances(List<CreateFleetInstance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CreateFleetInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<CreateFleetInstance>)
         */
        Builder instances(Consumer<CreateFleetInstance.Builder>... instances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String fleetId;

        private List<CreateFleetError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<CreateFleetInstance> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            super(model);
            fleetId(model.fleetId);
            errors(model.errors);
            instances(model.instances);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final List<CreateFleetError.Builder> getErrors() {
            List<CreateFleetError.Builder> result = CreateFleetErrorsSetCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CreateFleetError.BuilderImpl> errors) {
            this.errors = CreateFleetErrorsSetCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CreateFleetError> errors) {
            this.errors = CreateFleetErrorsSetCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CreateFleetError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CreateFleetError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> CreateFleetError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateFleetInstance.Builder> getInstances() {
            List<CreateFleetInstance.Builder> result = CreateFleetInstancesSetCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<CreateFleetInstance.BuilderImpl> instances) {
            this.instances = CreateFleetInstancesSetCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<CreateFleetInstance> instances) {
            this.instances = CreateFleetInstancesSetCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(CreateFleetInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<CreateFleetInstance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> CreateFleetInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
