/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageTask;

public class DescribeImportImageTasksPublisher
implements SdkPublisher<DescribeImportImageTasksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImportImageTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImportImageTasksPublisher(Ec2AsyncClient client, DescribeImportImageTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImportImageTasksPublisher(Ec2AsyncClient client, DescribeImportImageTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImportImageTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImportImageTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportImageTask> importImageTasks() {
        Function<DescribeImportImageTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.importImageTasks() != null) {
                return response.importImageTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImportImageTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImportImageTasksResponseFetcher
    implements AsyncPageFetcher<DescribeImportImageTasksResponse> {
        private DescribeImportImageTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportImageTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImportImageTasksResponse> nextPage(DescribeImportImageTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportImageTasksPublisher.this.client.describeImportImageTasks(DescribeImportImageTasksPublisher.this.firstRequest);
            }
            return DescribeImportImageTasksPublisher.this.client.describeImportImageTasks((DescribeImportImageTasksRequest)((Object)DescribeImportImageTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

