/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation;

public class DescribeTrunkInterfaceAssociationsIterable
implements SdkIterable<DescribeTrunkInterfaceAssociationsResponse> {
    private final Ec2Client client;
    private final DescribeTrunkInterfaceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrunkInterfaceAssociationsIterable(Ec2Client client, DescribeTrunkInterfaceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrunkInterfaceAssociationsResponseFetcher();
    }

    public Iterator<DescribeTrunkInterfaceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrunkInterfaceAssociation> interfaceAssociations() {
        Function<DescribeTrunkInterfaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.interfaceAssociations() != null) {
                return response.interfaceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrunkInterfaceAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeTrunkInterfaceAssociationsResponse> {
        private DescribeTrunkInterfaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrunkInterfaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrunkInterfaceAssociationsResponse nextPage(DescribeTrunkInterfaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrunkInterfaceAssociationsIterable.this.client.describeTrunkInterfaceAssociations(DescribeTrunkInterfaceAssociationsIterable.this.firstRequest);
            }
            return DescribeTrunkInterfaceAssociationsIterable.this.client.describeTrunkInterfaceAssociations((DescribeTrunkInterfaceAssociationsRequest)((Object)DescribeTrunkInterfaceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

