/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.PortRangeListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallStatefulRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallStatefulRule> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(FirewallStatefulRule.getter(FirewallStatefulRule::ruleGroupArn)).setter(FirewallStatefulRule.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").unmarshallLocationName("ruleGroupArn").build()}).build();
    private static final SdkField<List<String>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(FirewallStatefulRule.getter(FirewallStatefulRule::sources)).setter(FirewallStatefulRule.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSet").unmarshallLocationName("sourceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(FirewallStatefulRule.getter(FirewallStatefulRule::destinations)).setter(FirewallStatefulRule.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSet").unmarshallLocationName("destinationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> SOURCE_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePorts").getter(FirewallStatefulRule.getter(FirewallStatefulRule::sourcePorts)).setter(FirewallStatefulRule.setter(Builder::sourcePorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortSet").unmarshallLocationName("sourcePortSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> DESTINATION_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPorts").getter(FirewallStatefulRule.getter(FirewallStatefulRule::destinationPorts)).setter(FirewallStatefulRule.setter(Builder::destinationPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortSet").unmarshallLocationName("destinationPortSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(FirewallStatefulRule.getter(FirewallStatefulRule::protocol)).setter(FirewallStatefulRule.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(FirewallStatefulRule.getter(FirewallStatefulRule::ruleAction)).setter(FirewallStatefulRule.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(FirewallStatefulRule.getter(FirewallStatefulRule::direction)).setter(FirewallStatefulRule.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").unmarshallLocationName("direction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD, SOURCES_FIELD, DESTINATIONS_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, DIRECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleGroupArn;
    private final List<String> sources;
    private final List<String> destinations;
    private final List<PortRange> sourcePorts;
    private final List<PortRange> destinationPorts;
    private final String protocol;
    private final String ruleAction;
    private final String direction;

    private FirewallStatefulRule(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.sources = builder.sources;
        this.destinations = builder.destinations;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.direction = builder.direction;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<String> sources() {
        return this.sources;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final boolean hasSourcePorts() {
        return this.sourcePorts != null && !(this.sourcePorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> sourcePorts() {
        return this.sourcePorts;
    }

    public final boolean hasDestinationPorts() {
        return this.destinationPorts != null && !(this.destinationPorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> destinationPorts() {
        return this.destinationPorts;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String ruleAction() {
        return this.ruleAction;
    }

    public final String direction() {
        return this.direction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePorts() ? this.sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPorts() ? this.destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.direction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatefulRule)) {
            return false;
        }
        FirewallStatefulRule other = (FirewallStatefulRule)obj;
        return Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasSourcePorts() == other.hasSourcePorts() && Objects.equals(this.sourcePorts(), other.sourcePorts()) && this.hasDestinationPorts() == other.hasDestinationPorts() && Objects.equals(this.destinationPorts(), other.destinationPorts()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleAction(), other.ruleAction()) && Objects.equals(this.direction(), other.direction());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallStatefulRule").add("RuleGroupArn", (Object)this.ruleGroupArn()).add("Sources", this.hasSources() ? this.sources() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("SourcePorts", this.hasSourcePorts() ? this.sourcePorts() : null).add("DestinationPorts", this.hasDestinationPorts() ? this.destinationPorts() : null).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleAction()).add("Direction", (Object)this.direction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "SourcePorts": {
                return Optional.ofNullable(clazz.cast(this.sourcePorts()));
            }
            case "DestinationPorts": {
                return Optional.ofNullable(clazz.cast(this.destinationPorts()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleAction()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.direction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallStatefulRule, T> g) {
        return obj -> g.apply((FirewallStatefulRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleGroupArn;
        private List<String> sources = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> sourcePorts = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> destinationPorts = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private String ruleAction;
        private String direction;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallStatefulRule model) {
            this.ruleGroupArn(model.ruleGroupArn);
            this.sources(model.sources);
            this.destinations(model.destinations);
            this.sourcePorts(model.sourcePorts);
            this.destinationPorts(model.destinationPorts);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.direction(model.direction);
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final Collection<String> getSources() {
            if (this.sources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
        }

        @Override
        public final Builder sources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(String ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final List<PortRange.Builder> getSourcePorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.sourcePorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourcePorts(Collection<PortRange.BuilderImpl> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copyFromBuilder(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<PortRange> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(PortRange ... sourcePorts) {
            this.sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(Consumer<PortRange.Builder> ... sourcePorts) {
            this.sourcePorts(Stream.of(sourcePorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PortRange.Builder> getDestinationPorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.destinationPorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPorts(Collection<PortRange.BuilderImpl> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copyFromBuilder(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<PortRange> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(PortRange ... destinationPorts) {
            this.destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Consumer<PortRange.Builder> ... destinationPorts) {
            this.destinationPorts(Stream.of(destinationPorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public FirewallStatefulRule build() {
            return new FirewallStatefulRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallStatefulRule> {
        public Builder ruleGroupArn(String var1);

        public Builder sources(Collection<String> var1);

        public Builder sources(String ... var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder sourcePorts(Collection<PortRange> var1);

        public Builder sourcePorts(PortRange ... var1);

        public Builder sourcePorts(Consumer<PortRange.Builder> ... var1);

        public Builder destinationPorts(Collection<PortRange> var1);

        public Builder destinationPorts(PortRange ... var1);

        public Builder destinationPorts(Consumer<PortRange.Builder> ... var1);

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder direction(String var1);
    }
}

