/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ClassicLinkInstance;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;

public class DescribeClassicLinkInstancesIterable
implements SdkIterable<DescribeClassicLinkInstancesResponse> {
    private final Ec2Client client;
    private final DescribeClassicLinkInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClassicLinkInstancesIterable(Ec2Client client, DescribeClassicLinkInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClassicLinkInstancesResponseFetcher();
    }

    public Iterator<DescribeClassicLinkInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClassicLinkInstance> instances() {
        Function<DescribeClassicLinkInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClassicLinkInstancesResponseFetcher
    implements SyncPageFetcher<DescribeClassicLinkInstancesResponse> {
        private DescribeClassicLinkInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClassicLinkInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClassicLinkInstancesResponse nextPage(DescribeClassicLinkInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeClassicLinkInstancesIterable.this.client.describeClassicLinkInstances(DescribeClassicLinkInstancesIterable.this.firstRequest);
            }
            return DescribeClassicLinkInstancesIterable.this.client.describeClassicLinkInstances((DescribeClassicLinkInstancesRequest)((Object)DescribeClassicLinkInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

